/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_cy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_la = "Lladin";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_su = "Swndaneg";
        final String metaValue_syr = "Syrieg";
        final String metaValue_te = "Telugu";
        final Object[][] data = new Object[][] {
            { "001", "Y Byd" },
            { "002", "Affrica" },
            { "003", "Gogledd America" },
            { "005", "De America" },
            { "009", "Oceania" },
            { "011", "Gorllewin Affrica" },
            { "013", "Canolbarth America" },
            { "014", "Dwyrain Affrica" },
            { "015", "Gogledd Affrica" },
            { "017", "Canol Affrica" },
            { "018", "Deheudir Affrica" },
            { "019", "Yr Amerig" },
            { "021", "America i\u2019r Gogledd o Fecsico" },
            { "029", "Y Carib\u00ee" },
            { "030", "Dwyrain Asia" },
            { "034", "De Asia" },
            { "035", "De-Ddwyrain Asia" },
            { "039", "De Ewrop" },
            { "053", "Awstralasia" },
            { "054", "Melanesia" },
            { "057", "Rhanbarth Micronesia" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Canol Asia" },
            { "145", "Gorllewin Asia" },
            { "150", "Ewrop" },
            { "151", "Dwyrain Ewrop" },
            { "154", "Gogledd Ewrop" },
            { "155", "Gorllewin Ewrop" },
            { "202", "Affrica Is-Sahara" },
            { "419", "America Ladin" },
            { "AC", "Ynys Ascension" },
            { "AD", "Andorra" },
            { "AE", "Emiradau Arabaidd Unedig" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Yr Ariannin" },
            { "AS", "Samoa America" },
            { "AT", "Awstria" },
            { "AU", "Awstralia" },
            { "AW", "Aruba" },
            { "AX", "Ynysoedd \u00c5land" },
            { "AZ", "Aserbaijan" },
            { "BA", "Bosnia a Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Gwlad Belg" },
            { "BF", "Burkina Faso" },
            { "BG", "Bwlgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolifia" },
            { "BQ", "Antilles yr Iseldiroedd" },
            { "BR", "Brasil" },
            { "BS", "Y Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Ynys Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarws" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Ynysoedd Cocos (Keeling)" },
            { "CD", "Y Congo - Kinshasa" },
            { "CF", "Gweriniaeth Canolbarth Affrica" },
            { "CG", "Y Congo - Brazzaville" },
            { "CH", "Y Swistir" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Ynysoedd Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u0175n" },
            { "CN", "Tsieina" },
            { "CO", "Colombia" },
            { "CP", "Ynys Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Ciwba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Ynys y Nadolig" },
            { "CY", "Cyprus" },
            { "CZ", "Tsiecia" },
            { "DE", "Yr Almaen" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmarc" },
            { "DM", "Dominica" },
            { "DO", "Gweriniaeth Dominica" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Yr Aifft" },
            { "EH", "Gorllewin Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Sbaen" },
            { "ET", "Ethiopia" },
            { "EU", "Yr Undeb Ewropeaidd" },
            { "EZ", "Ardal yr Ewro" },
            { "FI", "Y Ffindir" },
            { "FJ", "Fiji" },
            { "FK", "Ynysoedd y Falkland/Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Ynysoedd Ffaro" },
            { "FR", "Ffrainc" },
            { "GA", "Gabon" },
            { "GB", "Y Deyrnas Unedig" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyane Ffrengig" },
            { "GG", "Ynys y Garn" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Yr Ynys Las" },
            { "GM", "Gambia" },
            { "GN", "Gini" },
            { "GP", "Guadeloupe" },
            { "GQ", "Gini Gyhydeddol" },
            { "GR", "Gwlad Groeg" },
            { "GS", "De Georgia ac Ynysoedd Sandwich y De" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guin\u00e9-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR Tsieina" },
            { "HM", "Ynys Heard ac Ynysoedd McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hwngari" },
            { "IC", "Yr Ynysoedd Dedwydd" },
            { "ID", "Indonesia" },
            { "IE", "Iwerddon" },
            { "IL", "Israel" },
            { "IM", "Ynys Manaw" },
            { "IN", "India" },
            { "IO", "Tiriogaeth Brydeinig Cefnfor India" },
            { "IQ", "Irac" },
            { "IR", "Iran" },
            { "IS", "Gwlad yr I\u00e2" },
            { "IT", "Yr Eidal" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Gwlad Iorddonen" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts a Nevis" },
            { "KP", "Gogledd Corea" },
            { "KR", "De Corea" },
            { "KW", "Kuwait" },
            { "KY", "Ynysoedd Cayman" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Libanus" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithwania" },
            { "LU", "Lwcsembwrg" },
            { "LV", "Latfia" },
            { "LY", "Libya" },
            { "MA", "Moroco" },
            { "MC", "Monaco" },
            { "MD", "Moldofa" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Ynysoedd Marshall" },
            { "MK", "Gogledd Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macau SAR Tsieina" },
            { "MP", "Ynysoedd Gogledd Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Y Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mecsico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Caledonia Newydd" },
            { "NE", "Niger" },
            { "NF", "Ynys Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Yr Iseldiroedd" },
            { "NO", "Norwy" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Seland Newydd" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Periw" },
            { "PF", "Polynesia Ffrengig" },
            { "PG", "Papua Guinea Newydd" },
            { "PH", "Y Philipinau" },
            { "PK", "Pakistan" },
            { "PL", "Gwlad Pwyl" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Ynysoedd Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Tiriogaethau Palesteinaidd" },
            { "PT", "Portiwgal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania Bellennig" },
            { "RE", "R\u00e9union" },
            { "RO", "Rwmania" },
            { "RS", "Serbia" },
            { "RU", "Rwsia" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Ynysoedd Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Swdan" },
            { "SE", "Sweden" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "SI", "Slofenia" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "SK", "Slofacia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "De Swdan" },
            { "ST", "S\u00e3o Tom\u00e9 a Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Ynysoedd Turks a Caicos" },
            { "TD", "Tsiad" },
            { "TF", "Tiroedd Deheuol ac Antarctig Ffrainc" },
            { "TG", "Togo" },
            { "TH", "Gwlad Thai" },
            { "TJ", "Tajicistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Tyrcmenistan" },
            { "TN", "Tiwnisia" },
            { "TO", "Tonga" },
            { "TR", "Twrci" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Wcr\u00e1in" },
            { "UG", "Uganda" },
            { "UM", "Ynysoedd Pellennig UDA" },
            { "UN", "y Cenhedloedd Unedig" },
            { "US", "Yr Unol Daleithiau" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Y Fatican" },
            { "VC", "Saint Vincent a\u2019r Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Ynysoedd Gwyryf Prydain" },
            { "VI", "Ynysoedd Gwyryf yr Unol Daleithiau" },
            { "VN", "Fietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XA", "Acenion Ffug" },
            { "XB", "Bidi Ffug" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "De Affrica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rhanbarth Anhysbys" },
            { "aa", "Affareg" },
            { "ab", "Abchaseg" },
            { "ae", "Afestaneg" },
            { "af", "Affric\u00e2neg" },
            { "ak", "Acaneg" },
            { "am", "Amhareg" },
            { "an", "Aragoneg" },
            { "ar", "Arabeg" },
            { "as", "Asameg" },
            { "av", "Afareg" },
            { "ay", "Aymareg" },
            { "az", "Aserbaijaneg" },
            { "ba", "Bashcorteg" },
            { "be", "Belarwseg" },
            { "bg", "Bwlgareg" },
            { "bi", "Bislama" },
            { "bm", "Bambareg" },
            { "bn", "Bengaleg" },
            { "bo", "Tibeteg" },
            { "br", "Llydaweg" },
            { "bs", "Bosnieg" },
            { "ca", "Catalaneg" },
            { "ce", "Tsietsieneg" },
            { "ch", "Tsiamorro" },
            { "co", "Corseg" },
            { "cr", "Cri" },
            { "cs", "Tsieceg" },
            { "cu", "Hen Slafoneg" },
            { "cv", "Tshwfasheg" },
            { "cy", "Cymraeg" },
            { "da", "Daneg" },
            { "de", "Almaeneg" },
            { "dv", "Difehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", "Groeg" },
            { "en", "Saesneg" },
            { "eo", "Esperanto" },
            { "es", "Sbaeneg" },
            { "et", "Estoneg" },
            { "eu", "Basgeg" },
            { "fa", "Perseg" },
            { "ff", "Ffwla" },
            { "fi", "Ffinneg" },
            { "fj", "Ffij\u00efeg" },
            { "fo", "Ffar\u00f6eg" },
            { "fr", "Ffrangeg" },
            { "fy", "Ffriseg y Gorllewin" },
            { "ga", "Gwyddeleg" },
            { "gd", "Gaeleg yr Alban" },
            { "gl", "Galisieg" },
            { "gn", "Guaran\u00ed" },
            { "gu", "Gwjarati" },
            { "gv", "Manaweg" },
            { "ha", "Hawsa" },
            { "he", "Hebraeg" },
            { "hi", "Hindi" },
            { "hr", "Croateg" },
            { "ht", "Creol Haiti" },
            { "hu", "Hwngareg" },
            { "hy", "Armeneg" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indoneseg" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Nwosw" },
            { "ik", "Inwpiaceg" },
            { "io", "Ido" },
            { "is", "Islandeg" },
            { "it", "Eidaleg" },
            { "iu", "Inwctitwt" },
            { "ja", "Japaneeg" },
            { "jv", "Jafanaeg" },
            { "ka", "Georgeg" },
            { "kg", "Congo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Casacheg" },
            { "kl", "Kalaallisut" },
            { "km", "Chmereg" },
            { "kn", "Kannada" },
            { "ko", "Coreeg" },
            { "kr", "Canwri" },
            { "ks", "Cashmireg" },
            { "ku", "Cwrdeg" },
            { "kv", "Comi" },
            { "kw", "Cernyweg" },
            { "ky", "Cirgiseg" },
            { "la", metaValue_la },
            { "lb", "Lwcsembwrgeg" },
            { "lg", "Ganda" },
            { "li", "Limbwrgeg" },
            { "ln", "Lingala" },
            { "lo", "Laoeg" },
            { "lt", "Lithwaneg" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latfieg" },
            { "mg", "Malagaseg" },
            { "mh", "Marsialeg" },
            { "mi", "M\u0101ori" },
            { "mk", "Macedoneg" },
            { "ml", "Malayalam" },
            { "mn", "Mongoleg" },
            { "mr", "Marathi" },
            { "ms", "Maleieg" },
            { "mt", "Malteg" },
            { "my", "Byrmaneg" },
            { "na", "Nawr\u0175eg" },
            { "nb", "Norwyeg Bokm\u00e5l" },
            { "nd", "Ndebele Gogleddol" },
            { "ne", "Nepaleg" },
            { "ng", "Ndonga" },
            { "nl", "Iseldireg" },
            { "nn", "Norwyeg Nynorsk" },
            { "no", "Norwyeg" },
            { "nr", "Ndebele Deheuol" },
            { "nv", "Nafaho" },
            { "ny", "Nianja" },
            { "oc", "Ocsitaneg" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Oseteg" },
            { "pa", "Pwnjabeg" },
            { "pi", "Pali" },
            { "pl", "Pwyleg" },
            { "ps", "Pashto" },
            { "pt", "Portiwgaleg" },
            { "qu", "Quechua" },
            { "rm", "Rom\u00e1nsh" },
            { "rn", "Rwndi" },
            { "ro", "Rwmaneg" },
            { "ru", "Rwseg" },
            { "rw", "Ciniar\u0175andeg" },
            { "sa", "Sansgrit" },
            { "sc", "Sardeg" },
            { "sd", "Sindhi" },
            { "se", "Sami Gogleddol" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croateg" },
            { "si", "Sinhaleg" },
            { "sk", "Slofaceg" },
            { "sl", "Slofeneg" },
            { "sm", "Sam\u00f6eg" },
            { "sn", "Shona" },
            { "so", "Somaleg" },
            { "sq", "Albaneg" },
            { "sr", "Serbeg" },
            { "ss", "Swati" },
            { "st", "Sesotheg Deheuol" },
            { "su", metaValue_su },
            { "sv", "Swedeg" },
            { "sw", "Swahili" },
            { "ta", "Tamileg" },
            { "te", metaValue_te },
            { "tg", "Tajiceg" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "tk", "Tyrcmeneg" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongeg" },
            { "tr", "Tyrceg" },
            { "ts", "Tsongaeg" },
            { "tt", "Tatareg" },
            { "tw", "Twi" },
            { "ty", "Tahit\u00efeg" },
            { "ug", "Uighur" },
            { "uk", "Wcreineg" },
            { "ur", "Wrdw" },
            { "uz", "Wsbeceg" },
            { "ve", "Fendeg" },
            { "vi", "Fietnameg" },
            { "vo", "Folap\u00fck" },
            { "wa", "Walwneg" },
            { "wo", "Woloff" },
            { "xh", "Xhosa" },
            { "yi", "Iddew-Almaeneg" },
            { "yo", "Iorwba" },
            { "zh", "Tsiein\u00ebeg" },
            { "zu", "Swlw" },
            { "ace", "Acehneg" },
            { "ach", "Acoli" },
            { "ada", "Adangmeg" },
            { "ady", "Circaseg Gorllewinol" },
            { "aeb", "Arabeg Tunisia" },
            { "afh", "Affrihili" },
            { "agq", "Aghemeg" },
            { "ain", "Ain\u0175eg" },
            { "akk", "Acadeg" },
            { "akz", "Alabam\u00e4eg" },
            { "ale", "Alewteg" },
            { "aln", "Ghegeg Albania" },
            { "alt", "Alt\u00e4eg Deheuol" },
            { "ang", "Hen Saesneg" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arc", "Aramaeg" },
            { "arn", "Arawcaneg" },
            { "aro", "Araonaeg" },
            { "arp", "Arapaho" },
            { "arq", "Arabeg Algeria" },
            { "ars", "Arabeg Najdi" },
            { "arw", "Arawaceg" },
            { "ary", "Arabeg Moroco" },
            { "arz", "Arabeg yr Aifft" },
            { "asa", "Asw" },
            { "ase", "Iaith Arwyddion America" },
            { "ast", "Astwrianeg" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "bal", "Balwtsi" },
            { "ban", "Bal\u00efeg" },
            { "bas", "Bas\u00e2eg" },
            { "bax", "Bamwmeg" },
            { "bej", "Bej\u00e4eg" },
            { "bem", "Bembeg" },
            { "bez", "Bena" },
            { "bfd", "Baffwteg" },
            { "bfq", "Badaga" },
            { "bgn", "Balochi Gorllewinol" },
            { "bho", "Bhojpuri" },
            { "bin", "Bini" },
            { "bkm", "Comeg" },
            { "bla", "Siksika" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Acwseg" },
            { "bua", "Bwriateg" },
            { "bug", "Bwginaeg" },
            { "bum", "Bwlw" },
            { "byn", "Blin" },
            { "cad", "Cado" },
            { "car", "Caribeg" },
            { "cay", "Cayuga" },
            { "cch", "Atsameg" },
            { "ccp", "Tsiacma" },
            { "ceb", "Cebuano" },
            { "cgg", "Tsiga" },
            { "chk", "Chuukaeg" },
            { "chm", "Marieg" },
            { "cho", "Siocto" },
            { "chp", "Chipewyan" },
            { "chr", "Tsieroc\u00ee" },
            { "chy", "Cheyenne" },
            { "ckb", "Cwrdeg Sorani" },
            { "clc", "Chilcotin" },
            { "cop", "Copteg" },
            { "crg", "Michif" },
            { "crh", "Tyrceg y Crimea" },
            { "crj", "Cree De Ddwyrain" },
            { "crk", "Plains Cree" },
            { "crl", "Gogledd Dwyrain Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "crs", "Ffrangeg Seselwa Creole" },
            { "csw", "Swampy Cree" },
            { "dak", "Dacotaeg" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "din", "Dinca" },
            { "dje", "Sarmaeg" },
            { "doi", "Dogri" },
            { "dsb", "Sorbeg Isaf" },
            { "dua", "Diwaleg" },
            { "dum", "Iseldireg Canol" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embw" },
            { "efi", "Efik" },
            { "egy", "Hen Eiffteg" },
            { "eka", "Ekajuk" },
            { "elx", "Elameg" },
            { "enm", "Saesneg Canol" },
            { "ewo", "Ewondo" },
            { "ext", "Extremadureg" },
            { "fat", "Ffanti" },
            { "fil", "Ffilipineg" },
            { "fit", "Ffinneg Tornedal" },
            { "fon", "Fon" },
            { "frc", "Ffrangeg Cajwn" },
            { "frm", "Ffrangeg Canol" },
            { "fro", "Hen Ffrangeg" },
            { "frp", "Arpitaneg" },
            { "frr", "Ffriseg Gogleddol" },
            { "frs", "Ffriseg y Dwyrain" },
            { "fur", "Ffriwleg" },
            { "gaa", "Ga" },
            { "gag", "Gagauz" },
            { "gay", "Gaio" },
            { "gba", "Gbaia" },
            { "gbz", "Dareg y Zoroastriaid" },
            { "gez", "Geez" },
            { "gil", "Gilberteg" },
            { "gmh", "Almaeneg Uchel Canol" },
            { "goh", "Hen Almaeneg Uchel" },
            { "gor", "Gorontalo" },
            { "got", "Gotheg" },
            { "grc", "Hen Roeg" },
            { "gsw", "Almaeneg y Swistir" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Haw\u00e4ieg" },
            { "hax", "Haida Deheuol" },
            { "hil", "Hiligaynon" },
            { "hit", "Hetheg" },
            { "hmn", "Hmongeg" },
            { "hsb", "Sorbeg Uchaf" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Ibaneg" },
            { "ibb", "Ibibio" },
            { "ikt", "Inuktitut Canadaidd Gorllewinol" },
            { "ilo", "Ilocaneg" },
            { "inh", "Ingwsieg" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Matsiame" },
            { "jpr", "Iddew-Bersieg" },
            { "jrb", "Iddew-Arabeg" },
            { "kaa", "Cara-Calpaceg" },
            { "kab", "Cabileg" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Camba" },
            { "kbd", "Cabardieg" },
            { "kcg", "Tyapeg" },
            { "kde", "Macondeg" },
            { "kea", "Caboferdianeg" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "C\u00e0seg" },
            { "khq", "Koyra Chiini" },
            { "khw", "Chowareg" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Concani" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Careleg" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Baffia" },
            { "ksh", "Cwleneg" },
            { "kum", "Cwmiceg" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "Iddew-Sbaeneg" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Lezgheg" },
            { "lil", "Lillooet" },
            { "lkt", "Lakota" },
            { "lmo", "Lombardeg" },
            { "lol", "Mongo" },
            { "lou", "Louisiana Creole" },
            { "loz", "Lozi" },
            { "lrc", "Luri Gogleddol" },
            { "lsm", "Saamia" },
            { "ltg", "Latgaleg" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lwnda" },
            { "luo", "L\u0175o" },
            { "lus", "Lwshaieg" },
            { "luy", "Lwyia" },
            { "mad", "Madwreg" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Macasareg" },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mdf", "Mocsia" },
            { "mdr", "Mandareg" },
            { "men", "Mendeg" },
            { "mer", "M\u00earw" },
            { "mfe", "Morisyen" },
            { "mga", "Gwyddeleg Canol" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta" },
            { "mic", "Micmaceg" },
            { "min", "Minangkabau" },
            { "mnc", "Manshw" },
            { "mni", "Manipwri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohoceg" },
            { "mos", "Mosi" },
            { "mrj", "Mari Gorllewinol" },
            { "mua", "Mundang" },
            { "mul", "Mwy nag un iaith" },
            { "mus", "Creek" },
            { "mwl", "Mirandeg" },
            { "mwr", "Marwari" },
            { "myv", "Erzya" },
            { "mzn", "Masanderani" },
            { "nap", "Naplieg" },
            { "naq", "Nama" },
            { "nds", "Almaeneg Isel" },
            { "new", "Newaeg" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "njo", "Ao Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Hen Norseg" },
            { "nqo", metaValue_nqo },
            { "nso", "Sotho Gogleddol" },
            { "nus", "N\u0175ereg" },
            { "nwc", "Hen Newari" },
            { "nym", "Niamwezi" },
            { "nyn", "Niancole" },
            { "nyo", "Nioro" },
            { "nzi", "Nzimeg" },
            { "ojb", "Ojibwa gogledd-orllewin" },
            { "ojc", "Ojibwa Canolog" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Ojibwa Gorllewinol" },
            { "oka", "Okanagan" },
            { "osa", "Osageg" },
            { "ota", "Tyrceg Otoman" },
            { "pag", "Pangasineg" },
            { "pal", "Pahlafi" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palawan" },
            { "pcd", "Picardeg" },
            { "pcm", "Pidgin Nigeria" },
            { "pdc", "Almaeneg Pensylfania" },
            { "peo", "Hen Bersieg" },
            { "pfl", "Almaeneg Palatin" },
            { "phn", "Phoeniceg" },
            { "pis", "Pijin" },
            { "pms", "Piedmonteg" },
            { "pnt", "Ponteg" },
            { "pon", "Pohnpeianeg" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Prwseg" },
            { "pro", "Hen Brofensaleg" },
            { "quc", "K\u2019iche\u2019" },
            { "raj", "Rajasthaneg" },
            { "rap", "Rapan\u0175i" },
            { "rar", "Raratongeg" },
            { "rhg", "Rohingya" },
            { "rof", "Rombo" },
            { "rom", "Romani" },
            { "rtm", "Rotumaneg" },
            { "rup", "Aromaneg" },
            { "rwk", "Rwa" },
            { "sad", "Sand\u00e4weg" },
            { "sah", "Sakha" },
            { "sam", "Aramaeg Samaria" },
            { "saq", "Samb\u0175rw" },
            { "sas", "Sasaceg" },
            { "sat", "Santali" },
            { "sba", "Ngambeieg" },
            { "sbp", "Sangw" },
            { "scn", "Sisileg" },
            { "sco", "Sgoteg" },
            { "sdc", "Sasareseg Sardinia" },
            { "sdh", "Cwrdeg Deheuol" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selcypeg" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Hen Wyddeleg" },
            { "sgs", "Samogiteg" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "shu", "Arabeg Chad" },
            { "sid", "Sidamo" },
            { "slh", "Lushootseed Deheuol" },
            { "sli", "Is-silesieg" },
            { "sma", "Sami Deheuol" },
            { "smj", "Sami Lwle" },
            { "smn", "Inari Sami" },
            { "sms", "Sami Scolt" },
            { "snk", "Soninceg" },
            { "sog", "Sogdeg" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serereg" },
            { "ssy", "Saho" },
            { "stq", "Ffriseg Saterland" },
            { "str", "Straits Salish" },
            { "suk", "Swcwma" },
            { "sus", "Sws\u0175eg" },
            { "sux", "Swmereg" },
            { "swb", "Comoreg" },
            { "syc", "Hen Syrieg" },
            { "syr", metaValue_syr },
            { "szl", "Silesieg" },
            { "tce", "Tutchone Deheuol" },
            { "tcy", "Tulu" },
            { "tem", "Timneg" },
            { "teo", "Teso" },
            { "ter", "Terena" },
            { "tet", "Tetumeg" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigreg" },
            { "tiv", "Tifeg" },
            { "tkl", "Tocelaweg" },
            { "tkr", "Tsakhureg" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tly", "Talysheg" },
            { "tmh", "Tamasheceg" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "tsd", "Tsaconeg" },
            { "ttm", "Tutchone gogleddol" },
            { "tum", "Twmbwca" },
            { "tvl", "Twfalweg" },
            { "twq", "Tasawaq" },
            { "tyv", "Twfwnieg" },
            { "tzm", "Tamazight Canol yr Atlas" },
            { "udm", "Fotiaceg" },
            { "uga", "Wgariteg" },
            { "umb", "Umbundu" },
            { "und", "Iaith anhysbys" },
            { "vai", "Faieg" },
            { "vec", "Feniseg" },
            { "vep", "Feps" },
            { "vls", "Fflemeg Gorllewinol" },
            { "vot", "Foteg" },
            { "vun", "Funjo" },
            { "wae", "Walsereg" },
            { "wal", "Walamo" },
            { "war", "Winarayeg" },
            { "was", "Washo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu Tsieineaidd" },
            { "xal", "Calmyceg" },
            { "xog", "Soga" },
            { "yav", "Iangben" },
            { "ybb", "Iembaeg" },
            { "yrl", "Nheengatu" },
            { "yue", "Cantoneeg" },
            { "zap", "Zapoteceg" },
            { "zbl", "Blisssymbols" },
            { "zea", "Z\u00ealandeg" },
            { "zgh", "Tamaseit Moroco Safonol" },
            { "zun", "Swni" },
            { "zxx", "Dim cynnwys ieithyddol" },
            { "zza", "Sas\u00e4eg" },
            { "Adlm", "Adlam" },
            { "Arab", "Arabaidd" },
            { "Aran", "Nastaliq" },
            { "Armn", "Armenaidd" },
            { "Beng", "Bangla" },
            { "Bopo", "Bopomofo" },
            { "Brai", "Braille" },
            { "Cakm", "Chakma" },
            { "Cans", "Meysydd Llafur Cynfrodorol Unedig Canada" },
            { "Cher", "Cherokee" },
            { "Cyrl", "Cyrilig" },
            { "Deva", "Devanagari" },
            { "Ethi", "Ethiopig" },
            { "Geor", "Georgaidd" },
            { "Grek", "Groegaidd" },
            { "Gujr", "Gwjarataidd" },
            { "Guru", "Gwrmwci" },
            { "Hanb", "Han gyda Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hans", "Symledig" },
            { "Hant", "Traddodiadol" },
            { "Hebr", "Hebreig" },
            { "Hira", "Hiragana" },
            { "Hrkt", "Syllwyddor Japaneaidd" },
            { "Jamo", "Jamo" },
            { "Jpan", "Japaneaidd" },
            { "Kana", "Catacana" },
            { "Khmr", "Chmeraidd" },
            { "Knda", "Canaraidd" },
            { "Kore", "Coreaidd" },
            { "Laoo", "Laoaidd" },
            { "Latn", metaValue_la },
            { "Mlym", "Malayalamaidd" },
            { "Mong", "Mongolaidd" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Myanmaraidd" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki" },
            { "Orya", "Or\u00efaidd" },
            { "Rohg", "Hanifi" },
            { "Sinh", "Sinhanaidd" },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", "Tamilaidd" },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinagh" },
            { "Thaa", "Thaana" },
            { "Thai", "Tai" },
            { "Tibt", "Tibetaidd" },
            { "Vaii", "Vai" },
            { "Yiii", "Yi" },
            { "Zmth", "Nodiant Mathemategol" },
            { "Zsye", "Emoji" },
            { "Zsym", "Symbolau" },
            { "Zxxx", "Anysgrifenedig" },
            { "Zyyy", "Cyffredin" },
            { "Zzzz", "Sgript anhysbys" },
            { "de_AT", "Almaeneg Awstria" },
            { "de_CH", "Almaeneg Safonol y Swistir" },
            { "en_AU", "Saesneg Awstralia" },
            { "en_CA", "Saesneg Canada" },
            { "en_GB", "Saesneg Prydain" },
            { "en_US", "Saesneg America" },
            { "es_ES", "Sbaeneg Ewrop" },
            { "es_MX", "Sbaeneg Mecsico" },
            { "fa_AF", "Dari" },
            { "fr_CA", "Ffrangeg Canada" },
            { "fr_CH", "Ffrangeg y Swistir" },
            { "nl_BE", "Fflemeg" },
            { "pt_BR", "Portiwgaleg Brasil" },
            { "pt_PT", "Portiwgaleg Ewrop" },
            { "ro_MD", "Moldofeg" },
            { "sw_CD", "Swahili\u2019r Congo" },
            { "%%1901", "orgraff draddodiadol yr Almaeneg" },
            { "ar_001", "Arabeg Modern Safonol" },
            { "es_419", "Sbaeneg America Ladin" },
            { "key.ca", "Calendr" },
            { "key.cf", "Fformat Arian" },
            { "key.co", "Trefn" },
            { "key.cu", "Math o Arian" },
            { "key.hc", "Cylched Awr (12 vs 24)" },
            { "key.lb", "Arddull Toriad Llinell" },
            { "key.ms", "System Fesur" },
            { "key.nu", "Rhifau" },
            { "nds_NL", "Sacsoneg Isel" },
            { "%%ALUKU", "tafodiaith Aluku" },
            { "%%KKCOR", "yr Orgraff Gyffredin" },
            { "%%KSCOR", "yr Orgraff Safonol" },
            { "%%NEDIS", "tafodiaith Natisone" },
            { "%%NJIVA", "tafodiaith Gniva/Njiva" },
            { "%%OSOJS", "tafodiaith Oseacco/Osojane" },
            { "%%POSIX", "Cyfrifiadur" },
            { "az_Arab", "Aserbaijaneg Deheuol" },
            { "hi_Latn", "Hindi (Lladin)" },
            { "zh_Hans", "Tsiein\u00ebeg Symledig" },
            { "zh_Hant", "Tsiein\u00ebeg Traddodiadol" },
            { "%%DAJNKO", "gwyddor Dajnko" },
            { "%%FONIPA", "Seineg IPA" },
            { "%%FONUPA", "Seineg UPA" },
            { "%%NDYUKA", "tafodiaith Ndyuka" },
            { "%%PAMAKA", "tafodiaith Pamaka" },
            { "%%AREVELA", "Armeneg Dwyreiniol" },
            { "%%AREVMDA", "Armeneg Gorllewinol" },
            { "%%BOHORIC", "Gwyddor Bohori\u010d" },
            { "%%EMODENG", "Saesneg Modern Cynnar" },
            { "%%METELKO", "gwyddor Metelko" },
            { "%%1606NICT", "Ffrangeg Canol Diweddar hyd at 1606" },
            { "%%1694ACAD", "Ffrangeg Modern Cynnar" },
            { "%%1959ACAD", "Academig" },
            { "%%SCOTLAND", "Saesneg Safonol yr Alban" },
            { "type.ca.roc", "Calendr Gweriniaeth Tseina" },
            { "type.co.eor", "Rheolau trefnu Ewropeaidd" },
            { "type.hc.h11", "System 12 Awr (0\u201311)" },
            { "type.hc.h12", "System 12 Awr (1\u201312)" },
            { "type.hc.h23", "System 24 Awr (0\u201323)" },
            { "type.hc.h24", "System 24 Awr (1\u201324)" },
            { "type.nu.arab", "Digidau Arabig-Indig" },
            { "type.nu.armn", "Rhifolion Armenaidd" },
            { "type.nu.beng", "Digidau Bengalaidd" },
            { "type.nu.cakm", "Digidau Chakma" },
            { "type.nu.deva", "Digidau Devanagarig" },
            { "type.nu.ethi", "Rhifolion Ethiopig" },
            { "type.nu.geor", "Rhifolion Georgaidd" },
            { "type.nu.grek", "Rhifolion Groegaidd" },
            { "type.nu.gujr", "Digidau Gwjarataidd" },
            { "type.nu.guru", "Digidau Gwrmwcaidd" },
            { "type.nu.hans", "Rhifolion Tsieineaidd Symledig" },
            { "type.nu.hant", "Rhifolion Tsieineaidd Traddodiadol" },
            { "type.nu.hebr", "Rhifolion Hebreig" },
            { "type.nu.java", "Digidau Jafanaidd" },
            { "type.nu.jpan", "Rhifolion Japaneaidd" },
            { "type.nu.khmr", "Digidau Chmeraidd" },
            { "type.nu.knda", "Digidau Kannaraidd" },
            { "type.nu.laoo", "Digidau Laoaidd" },
            { "type.nu.latn", "Digidau Gorllewinol" },
            { "type.nu.mlym", "Digidau Malayalamaidd" },
            { "type.nu.mong", "Digidau Mongolia" },
            { "type.nu.mtei", "Digidau Meetei Mayek" },
            { "type.nu.mymr", "Digidau Myanmar" },
            { "type.nu.olck", "Ol Chiki Digidau" },
            { "type.nu.orya", "Digidau Or\u00efaidd" },
            { "type.nu.takr", "Digidau Takri" },
            { "type.nu.taml", "Rhifolion Tamilaidd Traddodiadol" },
            { "type.nu.telu", "Digidau Telugu" },
            { "type.nu.thai", "Digidau Thai" },
            { "type.nu.tibt", "Digidau Tibetaidd" },
            { "type.nu.vaii", "Digidau Vai" },
            { "type.ca.dangi", "Calendr Dangi" },
            { "type.co.ducet", "Trefn Rhagosodedig Unicode" },
            { "type.lb.loose", "Arddull Toriad Llinell Rhydd" },
            { "type.nu.roman", "Rhifolion Rhufeinig" },
            { "type.ca.coptic", "Calendr y Coptiaid" },
            { "type.ca.hebrew", "Calendr Hebreaidd" },
            { "type.ca.indian", "Calendr Cenedlaethol India" },
            { "type.co.pinyin", "Trefn Pinyin" },
            { "type.co.search", "Chwilio at Ddibenion Cyffredinol" },
            { "type.co.zhuyin", "Trefn Zhuyin" },
            { "type.lb.normal", "Arddull Toriad Llinell Arferol" },
            { "type.lb.strict", "Arddull Torriad Llinell Caeth" },
            { "type.ms.metric", "System Fetrig" },
            { "type.ca.chinese", "Calendr Tseina" },
            { "type.ca.islamic", "Calendr Islam" },
            { "type.ca.iso8601", "Calendr ISO-8601" },
            { "type.ca.persian", "Calendr Persia" },
            { "type.cf.account", "Fformat Arian Cyfrifeg" },
            { "type.co.big5han", "Trefn Traddodiadol Tsieina - Big5" },
            { "type.nu.arabext", "Digidau Arabig-Indig Estynedig" },
            { "type.nu.armnlow", "Rhifolion Armenaidd mewn Llythrennau Bychain" },
            { "type.nu.greklow", "Rhifolion Groegaidd mewn Llythrennau Bychain" },
            { "type.nu.hanidec", "Rhifolion Degol Tsieineaidd" },
            { "type.nu.hansfin", "Rhifolion Ariannol Tsieineaidd Symledig" },
            { "type.nu.hantfin", "Rhifolion Ariannol Tsieineaidd Traddodiadol" },
            { "type.nu.jpanfin", "Rhifolion Ariannol Japaneaidd" },
            { "type.nu.tamldec", "Digidau Tamilaidd" },
            { "type.ca.buddhist", "Calendr Bwdaidd" },
            { "type.ca.ethiopic", "Calendr Ethiopia" },
            { "type.ca.japanese", "Calendr Japan" },
            { "type.cf.standard", "Fformat Arian Safonol" },
            { "type.co.reformed", "Trefn Diwygiedig" },
            { "type.co.standard", "Trefn Safonol" },
            { "type.ms.uksystem", "System Fesur Imperialaidd" },
            { "type.ms.ussystem", "System Fesur UDA" },
            { "type.nu.fullwide", "Digidau Lled Llawn" },
            { "type.nu.romanlow", "Rhifolion Rhufeinig mewn Llythrennau Bychain" },
            { "type.ca.gregorian", "Calendr Gregori" },
            { "type.co.gb2312han", "Trefn Symledig Tsieina - GB2312" },
            { "type.co.phonebook", "Trefn Llyfr Ff\u00f4n" },
            { "type.co.dictionary", "Trefn Geiriadur" },
            { "type.co.traditional", "Trefn Traddodiadol" },
            { "type.ca.islamic-civil", "Calendr Islamaidd (tabl, cyfnod sifil)" },
            { "type.ca.islamic-umalqura", "Calendr Islam (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Calendr Amete Alem Ethiopia" },
        };
        return data;
    }
}
