/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class TickBoxController
implements Controller<Boolean> {
    private final Option<Boolean> option;

    public TickBoxController(Option<Boolean> option) {
        this.option = option;
    }

    @Override
    public Option<Boolean> option() {
        return this.option;
    }

    @Override
    public Component formatValue() {
        return Component.empty();
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new TickBoxControllerElement(this, screen, widgetDimension);
    }

    public static class TickBoxControllerElement
    extends ControllerWidget<TickBoxController> {
        public TickBoxControllerElement(TickBoxController control, YACLScreen screen, Dimension<Integer> dim) {
            super(control, screen, dim);
        }

        @Override
        protected void drawHoveredControl(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            int outlineSize = 10;
            int outlineX1 = this.getDimension().xLimit() - this.getXPadding() - outlineSize;
            int outlineY1 = this.getDimension().centerY() - outlineSize / 2;
            int outlineX2 = this.getDimension().xLimit() - this.getXPadding();
            int outlineY2 = this.getDimension().centerY() + outlineSize / 2;
            int color = this.getValueColor();
            int shadowColor = this.multiplyColor(color, 0.25f);
            this.drawOutline(graphics, outlineX1 + 1, outlineY1 + 1, outlineX2 + 1, outlineY2 + 1, 1, shadowColor);
            this.drawOutline(graphics, outlineX1, outlineY1, outlineX2, outlineY2, 1, color);
            if (((TickBoxController)this.control).option().pendingValue().booleanValue()) {
                graphics.fill(outlineX1 + 3, outlineY1 + 3, outlineX2 - 1, outlineY2 - 1, shadowColor);
                graphics.fill(outlineX1 + 2, outlineY1 + 2, outlineX2 - 2, outlineY2 - 2, color);
            }
        }

        @Override
        protected void drawValueText(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (!this.isHovered()) {
                this.drawHoveredControl(graphics, mouseX, mouseY, delta);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.isMouseOver(mouseX, mouseY) || !this.isAvailable()) {
                return false;
            }
            this.toggleSetting();
            return true;
        }

        @Override
        protected int getHoveredControlWidth() {
            return 10;
        }

        @Override
        protected int getUnhoveredControlWidth() {
            return 10;
        }

        public void toggleSetting() {
            ((TickBoxController)this.control).option().requestSet(((TickBoxController)this.control).option().pendingValue() == false);
            this.playDownSound();
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (!this.focused) {
                return false;
            }
            if (keyCode == 257 || keyCode == 32 || keyCode == 335) {
                this.toggleSetting();
                return true;
            }
            return false;
        }
    }
}

