/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.Tag;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class WorldItemTagDataGen
extends ItemTagsProvider {
    public WorldItemTagDataGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, CompletableFuture<TagsProvider.TagLookup<Block>> blockLookup, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookup, blockLookup, modId, existingFileHelper);
    }

    @SafeVarargs
    private void addTagsTo(BlockContent content, TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender t = this.tag(tag);
            t.add((Object)content.item());
        }
    }

    @SafeVarargs
    private void addTagsTo(ItemContent content, TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender t = this.tag(tag);
            t.add((Object)content.item());
        }
    }

    @SafeVarargs
    private void addTagsTo(ItemLike content, TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender t = this.tag(tag);
            t.add((Object)content.asItem());
        }
    }

    @SafeVarargs
    private void addColorTags(XyCraftColors color, BlockContent content, TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            this.addTagsTo(content, tag);
        }
        this.addTagsTo(content, ((Tag)XyCraftTags.Items.XyColor.get(color)).tag());
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.addTagsTo(WorldContent.Block.Kivi, Tags.Items.STONES, XyCraftTags.Items.KiviItemBlock.tag(), XyCraftTags.Items.OreBearingGroundKivi.tag(), XyCraftTags.Items.Kivi.tag());
        this.addTagsTo(WorldContent.Block.KiviRajan, Tags.Items.STONES, XyCraftTags.Items.KiviItemBlock.tag());
        this.addTagsTo(WorldContent.Block.SmoothKivi, Tags.Items.STONES, XyCraftTags.Items.KiviItemBlock.tag());
        this.addTagsTo(WorldContent.Block.KiviBricks, ItemTags.STONE_BRICKS, XyCraftTags.Items.KiviItemBlock.tag());
        this.addTagsTo(WorldContent.Block.KiviTiles, ItemTags.STONE_BRICKS, XyCraftTags.Items.KiviItemBlock.tag());
        WorldContent.Block.KiviBricksCloud.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.KiviCloudGroup.tag()));
        WorldContent.Block.KiviTilesCloud.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.KiviCloudGroup.tag()));
        WorldContent.Block.KiviPillar.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.KiviCloudGroup.tag()));
        WorldContent.Block.KiviTrim.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.KiviCloudGroup.tag()));
        this.addTagsTo(WorldContent.Block.AluminumStorage, Tags.Items.STORAGE_BLOCKS, XyCraftTags.Items.StorageBlockAluminum.tag());
        this.addTagsTo(WorldContent.Block.RawAluminumBlock, Tags.Items.STORAGE_BLOCKS, XyCraftTags.Items.StorageBlockRawAluminum.tag());
        this.addTagsTo(WorldContent.Block.AluminumBricks, XyCraftTags.Items.AluminumItemBlock.tag());
        WorldContent.Block.AluminumBricksCloud.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.AluminumCloudGroup.tag()));
        WorldContent.Block.AluminumPillar.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.AluminumCloudGroup.tag()));
        WorldContent.Block.AluminumTrim.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.AluminumCloudGroup.tag()));
        this.addTagsTo(WorldContent.Block.AluminumTiles, XyCraftTags.Items.AluminumItemBlock.tag());
        WorldContent.Block.AluminumTilesCloud.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.AluminumCloudGroup.tag()));
        WorldContent.Block.InvertedBricksCloud.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.InvertedGroup.tag()));
        WorldContent.Block.InvertedTilesCloud.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.InvertedGroup.tag()));
        WorldContent.Block.MatteXychoriumBricks.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.InvertedGroup.tag()));
        WorldContent.Block.MatteXychoriumBricksShiny.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.InvertedGroup.tag()));
        WorldContent.Block.MatteXychoriumLayersShiny.forEach((color, blockContent) -> this.addColorTags((XyCraftColors)color, (BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.InvertedGroup.tag()));
        WorldContent.Block.XychoriumOreStone.forEach((color, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)Tags.Items.ORES, (TagKey<Item>)Tags.Items.ORES_IN_GROUND_STONE, (TagKey<Item>)Tags.Items.ORE_RATES_DENSE, (TagKey<Item>)XyCraftTags.Items.XychoriumOre.tag(), (TagKey<Item>)((Tag)XyCraftTags.Items.XyColor.get(color)).tag()));
        WorldContent.Block.XychoriumOreDeepslate.forEach((color, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)Tags.Items.ORES, (TagKey<Item>)Tags.Items.ORES_IN_GROUND_DEEPSLATE, (TagKey<Item>)Tags.Items.ORE_RATES_DENSE, (TagKey<Item>)XyCraftTags.Items.XychoriumOre.tag(), (TagKey<Item>)((Tag)XyCraftTags.Items.XyColor.get(color)).tag()));
        WorldContent.Block.XychoriumOreKivi.forEach((color, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)Tags.Items.ORES, (TagKey<Item>)XyCraftTags.Items.OreInGroundKivi.tag(), (TagKey<Item>)Tags.Items.ORE_RATES_DENSE, (TagKey<Item>)XyCraftTags.Items.XychoriumOre.tag(), (TagKey<Item>)((Tag)XyCraftTags.Items.XyColor.get(color)).tag()));
        this.addTagsTo(WorldContent.Block.AluminumOreStone, Tags.Items.ORES, Tags.Items.ORES_IN_GROUND_STONE, Tags.Items.ORE_RATES_SINGULAR, XyCraftTags.Items.AluminumOre.tag());
        this.addTagsTo(WorldContent.Block.AluminumOreDeepslate, Tags.Items.ORES, Tags.Items.ORES_IN_GROUND_DEEPSLATE, Tags.Items.ORE_RATES_SINGULAR, XyCraftTags.Items.AluminumOre.tag());
        this.addTagsTo(WorldContent.Block.AluminumOreKivi, Tags.Items.ORES, XyCraftTags.Items.OreInGroundKivi.tag(), Tags.Items.ORE_RATES_SINGULAR, XyCraftTags.Items.AluminumOre.tag());
        WorldContent.Block.XychoriumStorage.forEach((color, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS));
        this.addTagsTo(WorldContent.Block.GlassViewer, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_CHEAP, Tags.Items.GLASS_BLOCKS_COLORLESS);
        this.addTagsTo(WorldContent.Block.GlassViewerSilicon, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_CHEAP, Tags.Items.GLASS_BLOCKS_COLORLESS);
        this.addTagsTo(WorldContent.Block.GlassViewerDire, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_CHEAP, Tags.Items.GLASS_BLOCKS_COLORLESS);
        this.addTagsTo(WorldContent.Block.GlassViewerGlowing, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_COLORLESS, XyCraftTags.Items.GlassGlowing.tag());
        this.addTagsTo(WorldContent.Block.GlassViewerGlowingClear, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_COLORLESS, XyCraftTags.Items.GlassGlowing.tag());
        this.addTagsTo(WorldContent.Block.GlassViewerDark, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_TINTED);
        this.addTagsTo(WorldContent.Block.GlassViewerReinforced, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_COLORLESS);
        this.addTagsTo(WorldContent.Block.GlassViewerPhantom, Tags.Items.GLASS_BLOCKS);
        this.addTagsTo(WorldContent.Block.GlassViewerPhantomGlowing, Tags.Items.GLASS_BLOCKS, XyCraftTags.Items.GlassGlowing.tag());
        this.addTagsTo(WorldContent.Block.GlassViewerPhantomDark, Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS_TINTED);
        WorldContent.Block.LampLantern.forEach((dyeColor, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.Lamp.tag()));
        WorldContent.Block.LampPillar.forEach((dyeColor, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.Lamp.tag()));
        WorldContent.Block.LampCube.forEach((dyeColor, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.Lamp.tag()));
        WorldContent.Block.LampFlush.forEach((dyeColor, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)XyCraftTags.Items.Lamp.tag()));
        this.addTagsTo(WorldContent.Block.GlassViewerImmortal, Tags.Items.GLASS_BLOCKS, XyCraftTags.Items.GlassAluminum.tag());
        WorldContent.Block.GlassViewerRgb.forEach((color, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)Tags.Items.GLASS_BLOCKS, (TagKey<Item>)Tags.Items.DYED_BLACK, (TagKey<Item>)Tags.Items.DYED_BLUE, (TagKey<Item>)Tags.Items.DYED_BROWN, (TagKey<Item>)Tags.Items.DYED_CYAN, (TagKey<Item>)Tags.Items.DYED_BROWN, (TagKey<Item>)Tags.Items.DYED_GRAY, (TagKey<Item>)Tags.Items.DYED_GREEN, (TagKey<Item>)Tags.Items.DYED_LIGHT_BLUE, (TagKey<Item>)Tags.Items.DYED_LIGHT_GRAY, (TagKey<Item>)Tags.Items.DYED_LIME, (TagKey<Item>)Tags.Items.DYED_MAGENTA, (TagKey<Item>)Tags.Items.DYED_ORANGE, (TagKey<Item>)Tags.Items.DYED_RED, (TagKey<Item>)Tags.Items.DYED_WHITE, (TagKey<Item>)Tags.Items.DYED_YELLOW, (TagKey<Item>)XyCraftTags.Items.GlassColored.tag()));
        WorldContent.Block.GlassViewerRgbGlowing.forEach((color, blockContent) -> this.addTagsTo((BlockContent)blockContent, (TagKey<Item>)Tags.Items.GLASS_BLOCKS, (TagKey<Item>)Tags.Items.DYED_BLACK, (TagKey<Item>)Tags.Items.DYED_BLUE, (TagKey<Item>)Tags.Items.DYED_BROWN, (TagKey<Item>)Tags.Items.DYED_CYAN, (TagKey<Item>)Tags.Items.DYED_BROWN, (TagKey<Item>)Tags.Items.DYED_GRAY, (TagKey<Item>)Tags.Items.DYED_GREEN, (TagKey<Item>)Tags.Items.DYED_LIGHT_BLUE, (TagKey<Item>)Tags.Items.DYED_LIGHT_GRAY, (TagKey<Item>)Tags.Items.DYED_LIME, (TagKey<Item>)Tags.Items.DYED_MAGENTA, (TagKey<Item>)Tags.Items.DYED_ORANGE, (TagKey<Item>)Tags.Items.DYED_RED, (TagKey<Item>)Tags.Items.DYED_WHITE, (TagKey<Item>)Tags.Items.DYED_YELLOW, (TagKey<Item>)XyCraftTags.Items.GlassColored.tag(), (TagKey<Item>)XyCraftTags.Items.GlassGlowing.tag()));
        WorldContent.Item.XychoriumGem.forEach((color, blockContent) -> this.addTagsTo((ItemContent)blockContent, (TagKey<Item>)Tags.Items.GEMS, (TagKey<Item>)XyCraftTags.Items.XychoriumGem.tag(), (TagKey<Item>)((Tag)XyCraftTags.Items.XyColor.get(color)).tag()));
        this.addTagsTo(WorldContent.Item.RawAluminum, Tags.Items.RAW_MATERIALS, XyCraftTags.Items.AluminumRaw.tag());
        this.addTagsTo(WorldContent.Item.AluminumIngot, Tags.Items.INGOTS, XyCraftTags.Items.AluminumIngot.tag());
        this.addTagsTo(WorldContent.Item.AluminumNugget, Tags.Items.NUGGETS, XyCraftTags.Items.AluminumNugget.tag());
        this.addTagsTo((ItemLike)Blocks.BLACK_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.BLUE_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.BROWN_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.CYAN_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.BROWN_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.GRAY_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.GREEN_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.LIGHT_BLUE_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.LIGHT_GRAY_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.LIME_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.MAGENTA_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.ORANGE_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.RED_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.WHITE_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
        this.addTagsTo((ItemLike)Blocks.YELLOW_STAINED_GLASS, XyCraftTags.Items.GlassColored.tag());
    }

    private void appendTag(TagKey<Item> tag, Iterable<ItemContent> content) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender t = this.tag(tag);
        for (ItemContent itemContent : content) {
            t.add((Object)itemContent.item());
        }
    }

    private void appendTag(TagKey<Item> tag, BlockContent content) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender t = this.tag(tag);
        t.add((Object)content.item());
    }

    private void appendTag(TagKey<Item> tag, ItemContent content) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender t = this.tag(tag);
        t.add((Object)content.item());
    }
}

