/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.generation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.world.content.registries.WorldStructures;

public class SurfaceGeyserPiece
extends StructurePiece
implements PieceBeardifierModifier {
    private static final String NBT_KEY_BLOCK = "block_well";
    private final BlockState blockWell;
    private final BlockState surrounding;
    private static final Vec3i[] offsets = new Vec3i[]{new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, -1)};

    private static BoundingBox fromCenterBottom(BlockPos basePos, int radius, int height) {
        return new BoundingBox(basePos.getX() - radius, basePos.getY(), basePos.getZ() - radius, basePos.getX() + radius, basePos.getY() + height, basePos.getZ() + radius);
    }

    public SurfaceGeyserPiece(BlockPos nodePos, BlockState blockWell, float radius, float height) {
        super((StructurePieceType)WorldStructures.SurfaceNodePiece.value(), 0, SurfaceGeyserPiece.fromCenterBottom(nodePos, Math.max(Mth.ceil((float)(radius - 5.0f)), 0), Mth.ceil((float)height)));
        this.blockWell = blockWell;
        this.surrounding = Blocks.DRIPSTONE_BLOCK.defaultBlockState();
    }

    public SurfaceGeyserPiece(StructurePieceSerializationContext serializationContext, CompoundTag tag) {
        super((StructurePieceType)WorldStructures.SurfaceNodePiece.value(), tag);
        this.blockWell = NbtUtils.readBlockState((HolderGetter)serializationContext.registryAccess().lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound(NBT_KEY_BLOCK));
        this.surrounding = Blocks.DRIPSTONE_BLOCK.defaultBlockState();
    }

    protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext serializationContext, CompoundTag tag) {
        tag.put(NBT_KEY_BLOCK, (Tag)NbtUtils.writeBlockState((BlockState)this.blockWell));
    }

    public void postProcess(@NotNull WorldGenLevel level, @NotNull StructureManager manager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, BoundingBox chunkBox, @NotNull ChunkPos chunkPos, @NotNull BlockPos startBottomCenter) {
        if (chunkBox.isInside((Vec3i)startBottomCenter)) {
            this.placeWell(level, startBottomCenter);
        }
    }

    private void placeWell(WorldGenLevel level, BlockPos placementPos) {
        for (Vec3i offset : offsets) {
            BlockPos offsetPos = placementPos.offset(offset);
            level.setBlock(offsetPos, this.surrounding, 2);
            level.getChunk(offsetPos).markPosForPostprocessing(offsetPos);
        }
        level.setBlock(placementPos, this.blockWell, 2);
        level.getChunk(placementPos).markPosForPostprocessing(placementPos);
    }

    @NotNull
    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    @NotNull
    public TerrainAdjustment getTerrainAdjustment() {
        return TerrainAdjustment.BEARD_THIN;
    }

    public int getGroundLevelDelta() {
        return 1;
    }
}

