/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class PhantomGlassViewerBlock
extends XyBlock {
    private static final VoxelShape _top = PhantomGlassViewerBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public PhantomGlassViewerBlock(BlockBehaviour.Properties properties) {
        super(properties.noCollission().forceSolidOn());
    }

    public static PhantomGlassViewerBlock glow(BlockBehaviour.Properties properties) {
        return new PhantomGlassViewerBlock(properties.noCollission().forceSolidOn().lightLevel(value -> 15));
    }

    @NotNull
    public VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return Shapes.empty();
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        return false;
    }

    public boolean canBeReplaced(@NotNull BlockState p_60535_, @NotNull Fluid p_60536_) {
        return false;
    }

    private boolean isDark(@NotNull BlockState state) {
        return state.getBlock() == WorldContent.Block.GlassViewerPhantomDark.block();
    }

    public int getLightBlock(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.isDark(state) ? level.getMaxLightLevel() : super.getLightBlock(state, level, pos);
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return !this.isDark(state);
    }

    public float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1.0f;
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return _top;
    }

    public boolean skipRendering(@NotNull BlockState state, BlockState otherState, @NotNull Direction direction) {
        return otherState.is((Block)this) || super.skipRendering(state, otherState, direction);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Mob mob, @NotNull PathType originalType) {
        return PathType.BLOCKED;
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        Entity entity;
        EntityCollisionContext eCtx;
        if (ctx instanceof EntityCollisionContext && (eCtx = (EntityCollisionContext)ctx).getEntity() != null && (entity = eCtx.getEntity()).getType() != EntityType.PLAYER && entity.getType() != EntityType.ITEM && entity.getType() != EntityType.EXPERIENCE_ORB) {
            return Shapes.block();
        }
        return super.getCollisionShape(state, level, pos, ctx);
    }

    @Deprecated
    public boolean isSolid() {
        return true;
    }
}

