/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.registries.IRegister;
import tv.soaryn.xycraft.world.content.registries.WorldAttachments;
import tv.soaryn.xycraft.world.content.registries.WorldContent;
import tv.soaryn.xycraft.world.content.registries.WorldParticles;
import tv.soaryn.xycraft.world.content.registries.WorldStructures;

@Mod(value="xycraft_world")
public class XyWorld
extends XyCraft {
    public static final String ModId = "xycraft_world";

    public static ResourceLocation resource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)ModId, (String)name);
    }

    public XyWorld(IEventBus bus) {
        super(bus, new IRegister[]{WorldParticles.Instance, WorldContent.Map, WorldAttachments.Instance, WorldStructures.Instance});
        bus.addListener(this::addToCreativeTabs);
    }

    private void addToCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        IContent[] itemsInTab;
        for (IContent content2 : itemsInTab = (IContent[])WorldContent.Map.MappedContent.stream().filter(content -> content.tab() != null && content.tab().isBound() && content.tab().get() == event.getTab()).toArray(IContent[]::new)) {
            if (content2 instanceof ItemContent) {
                ItemContent itemContent = (ItemContent)content2;
                event.accept((ItemLike)itemContent.item());
                continue;
            }
            if (!(content2 instanceof BlockContent)) continue;
            BlockContent blockContent = (BlockContent)content2;
            event.accept((ItemLike)blockContent.item());
        }
    }
}

