/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.temp;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tv.soaryn.xycraft.machines.temp.FacingWithSpinStrategy;
import tv.soaryn.xycraft.machines.temp.IOrientableBlock;

public interface IOrientationStrategy {
    public static final IOrientationStrategy none = Collections::emptyList;
    public static final IOrientationStrategy full = new FacingWithSpinStrategy();
    public static final Direction[][] _upDirections = new Direction[][]{{Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.EAST}, {Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}, {Direction.UP, Direction.WEST, Direction.DOWN, Direction.EAST}, {Direction.UP, Direction.EAST, Direction.DOWN, Direction.WEST}, {Direction.UP, Direction.SOUTH, Direction.DOWN, Direction.NORTH}, {Direction.UP, Direction.NORTH, Direction.DOWN, Direction.SOUTH}};

    public static IOrientationStrategy get(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof IOrientableBlock) {
            IOrientableBlock orientableBlock = (IOrientableBlock)block;
            return orientableBlock.getOrientationStrategy();
        }
        return none;
    }

    default public Direction getFacing(BlockState state) {
        return Direction.NORTH;
    }

    default public int getSpin(BlockState state) {
        return 0;
    }

    default public BlockState setFacing(BlockState state, Direction facing) {
        return state;
    }

    default public BlockState setSpin(BlockState state, int spin) {
        return state;
    }

    default public BlockState setUp(BlockState state, Direction up) {
        Direction facing = this.getFacing(state);
        int spin = IOrientationStrategy.getUp(facing, up);
        return this.setSpin(state, spin);
    }

    public static int getUp(Direction facing, Direction up) {
        Direction[] upDirs = _upDirections[facing.ordinal()];
        for (int i = 0; i < upDirs.length; ++i) {
            if (upDirs[i] != up) continue;
            return i;
        }
        return 0;
    }

    default public BlockState setOrientation(BlockState state, Direction facing, int spin) {
        return this.setSpin(this.setFacing(state, facing), spin);
    }

    default public BlockState setOrientation(BlockState state, Direction facing, Direction up) {
        return this.setUp(this.setFacing(state, facing), up);
    }

    default public BlockState getStateForPlacement(BlockState state, BlockPlaceContext context) {
        return state;
    }

    public Collection<Property<?>> getProperties();
}

