/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.mixins;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.SkyLightEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.machines.content.volumes.IlluminationVolume;
import tv.soaryn.xycraft.machines.utils.mixins.ILightMixinInterface;

@Mixin(value={LightEngine.class})
public abstract class LightEngineMixin
implements ILightMixinInterface {
    @Unique
    public final LongOpenHashSet xycraft$volumesToCheck = new LongOpenHashSet(512, 0.5f);
    @Final
    @Shadow
    protected LightChunkGetter chunkSource;
    @Shadow
    @Final
    protected LayerLightSectionStorage storage;
    @Shadow
    @Final
    private LongOpenHashSet blockNodesToCheck;
    @Shadow
    @Final
    protected static long PULL_LIGHT_IN_ENTRY;
    private static final long REMOVE_SKY_SOURCE_ENTRY;
    private static final long ADD_SKY_SOURCE_ENTRY;

    @Override
    public void xycraft$checkVolume(BlockPos pos) {
        this.xycraft$volumesToCheck.add(pos.asLong());
    }

    @Shadow
    protected abstract BlockState getState(BlockPos var1);

    @Shadow
    protected abstract void enqueueIncrease(long var1, long var3);

    @Shadow
    protected abstract void enqueueDecrease(long var1, long var3);

    @Shadow
    protected abstract void checkNode(long var1);

    @Inject(method={"runLightUpdates"}, at={@At(value="HEAD")})
    private void xycraft$runLightUpdate(CallbackInfoReturnable<Integer> cir) {
        BlockGetter blockGetter = this.chunkSource.getLevel();
        if (!(blockGetter instanceof Level)) {
            return;
        }
        Level level = (Level)blockGetter;
        boolean isSkyEngine = this instanceof SkyLightEngine;
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, IlluminationVolume.class);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        LongIterator nodeIt = this.blockNodesToCheck.iterator();
        while (nodeIt.hasNext()) {
            long node = nodeIt.nextLong();
            lookup.getAllBoxes(BlockPos.of((long)node)).mapToLong(BlockPos::asLong).forEach(arg_0 -> ((LongOpenHashSet)this.xycraft$volumesToCheck).add(arg_0));
        }
        LongIterator it = this.xycraft$volumesToCheck.longIterator();
        while (it.hasNext()) {
            long blockPosId = it.nextLong();
            long section = SectionPos.blockToSection((long)blockPosId);
            if (!this.storage.storingLightForSection(section)) continue;
            int x = BlockPos.getX((long)blockPosId);
            int y = BlockPos.getY((long)blockPosId);
            int z = BlockPos.getZ((long)blockPosId);
            int lowestSource = this.storage.lightOnInSection(section) ? this.xycraft$getLowestSourceY(x, z, Integer.MAX_VALUE) : Integer.MAX_VALUE;
            BlockState blockstate = this.getState((BlockPos)mutablePos.set(blockPosId));
            int currentValue = this.storage.getStoredLevel(blockPosId);
            if (isSkyEngine) {
                this.checkNode(blockPosId);
                continue;
            }
            OptionalInt v = lookup.find(BlockPos.of((long)blockPosId)).filter(volume -> volume.isStateValid(this.getState(volume.getPos()))).mapToInt(volume -> volume.getLightLevel(this.getState(volume.getPos()))).max();
            if (v.isEmpty()) {
                this.checkNode(blockPosId);
                continue;
            }
            int volumeValue = v.getAsInt();
            if (volumeValue < currentValue) {
                this.storage.setStoredLevel(blockPosId, 0);
                this.enqueueDecrease(blockPosId, LightEngine.QueueEntry.decreaseAllDirections((int)currentValue));
            } else {
                this.enqueueDecrease(blockPosId, PULL_LIGHT_IN_ENTRY);
            }
            if (volumeValue <= 0) continue;
            this.enqueueIncrease(blockPosId, LightEngine.QueueEntry.increaseLightFromEmission((int)volumeValue, (!blockstate.canOcclude() || !blockstate.useShapeForLightOcclusion() ? 1 : 0) != 0));
        }
        this.xycraft$volumesToCheck.clear();
        this.xycraft$volumesToCheck.trim(512);
    }

    private int xycraft$getLowestSourceY(int p_285058_, int p_285191_, int p_285111_) {
        ChunkSkyLightSources chunkskylightsources = this.xycraft$getChunkSources(SectionPos.blockToSectionCoord((int)p_285058_), SectionPos.blockToSectionCoord((int)p_285191_));
        return chunkskylightsources == null ? p_285111_ : chunkskylightsources.getLowestSourceY(SectionPos.sectionRelative((int)p_285058_), SectionPos.sectionRelative((int)p_285191_));
    }

    @Nullable
    private ChunkSkyLightSources xycraft$getChunkSources(int p_285270_, int p_285307_) {
        LightChunk lightchunk = this.chunkSource.getChunkForLighting(p_285270_, p_285307_);
        return lightchunk != null ? lightchunk.getSkyLightSources() : null;
    }

    static {
        REMOVE_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.decreaseSkipOneDirection((int)15, (Direction)Direction.UP);
        ADD_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.increaseSkipOneDirection((int)15, (boolean)false, (Direction)Direction.UP);
    }
}

