/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotClickPacket;
import tv.soaryn.xycraft.core.network.packets.SBMenuComponentMessagePacket;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IClickCallback;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableBackground;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableButton;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableCanvas;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFrame;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableImage;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.gui.FabricatorMenu;

public class FabricatorUI
extends BaseMenuUI<FabricatorMenu> {
    private static final ResourceLocation[] locs = new ResourceLocation[]{XyCore.resource((String)"textures/gui/always_on.png"), XyCore.resource((String)"textures/gui/high_signal.png"), XyCore.resource((String)"textures/gui/pulse.png")};
    private static final String[] buttonDescriptions = new String[]{"gui.xycraft_machines.fabricator.always_on", "gui.xycraft_machines.fabricator.high_signal", "gui.xycraft_machines.fabricator.pulse"};
    private final BaseMenuUI.LerpContext lerpContext = new BaseMenuUI.LerpContext();
    private static final int buttonHighlightColor = -48060;
    private static final int buttonSize = 22;
    private final ResourceLocation glowArrowLoc = XyMachines.resource("textures/gui/icons/arrow_glow.png");
    private final ResourceLocation arrowFullLoc = XyMachines.resource("textures/gui/icons/arrow_full.png");
    private final NineSlicedResource thinBorder = new NineSlicedResource(XyCore.resource((String)"textures/gui/sliced/border_thin.png"));

    public FabricatorUI(FabricatorMenu menu, Inventory playerInv, Component title) {
        super((BaseMenu)menu, playerInv, title, 200, 192);
    }

    protected void init() {
        super.init();
        this.lerpContext.TargetColor = this.lerpContext.CurrentColor = FavoredColor.of((IAttachmentHolder)((FabricatorMenu)this.menu).BlockEntity);
        this.lerpContext.Time = 1.0f;
        ((DrawableCanvas)this.rootCanvas.addChild(DrawableCanvas::create, canvas -> {
            canvas.dimensions(-8.0f, -8.0f, canvas.Parent.Dimensions.width + 16.0f, 100.0f);
            canvas.addChild(DrawableFrame::create, panel -> {
                ((DrawableFrame)((DrawableFrame)panel.texture(this.thinBorder).dimensions(-30.0f, 0.0f, 60.0f, 0.0f).fillParentVertical()).scale(1.0f, 0.9f)).addChild(DrawableBackground::create, drawableBackground -> ((DrawableBackground)drawableBackground.fillParent()).color(-13355980));
                for (int i = 0; i < 3; ++i) {
                    this.addButton((DrawableFrame)panel, i);
                }
            });
            canvas.addChild(DrawableFrame::create, window -> ((DrawableFrame)((DrawableFrame)((DrawableFrame)((DrawableFrame)window.fillParent()).addChild(DrawableBackground::create, bgrnd -> ((DrawableBackground)((DrawableBackground)((DrawableBackground)bgrnd.fillParent()).color(FavoredColor.of((IAttachmentHolder)((FabricatorMenu)this.menu).BlockEntity))).onContainerTick((widget, time) -> FabricatorUI.setLerpTargetForBlockEntity((DrawableBackground)widget, (BlockEntity)((FabricatorMenu)this.getMenu()).BlockEntity, (BaseMenuUI.LerpContext)this.lerpContext))).onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> FabricatorUI.lerpWidgetColorForBlockEntity((DrawableBackground)widget, (float)partialTick, (BaseMenuUI.LerpContext)this.lerpContext)))).addChild(DrawableImage::create, arrow -> this.handleArrow((DrawableImage)arrow, 75, -1146443094, -864585865))).addChild(DrawableImage::create, arrow -> this.handleArrow((DrawableImage)arrow, 111, -1429436331, -578267870))).addChild(DrawableFrame::create, inventoryPanel -> inventoryPanel.texture(this.thinBorder).dimensions(window.Dimensions.width - 90.0f, 11.0f, 78.0f, 78.0f).addChild(DrawableBackground::create, t -> ((DrawableBackground)t.fillParent()).color(ColorUtils.Dye.Orange.getColor()))));
        })).addChild(DrawableFrame::create, arg_0 -> ((FabricatorUI)this).defaultPlayerPanel(arg_0));
    }

    private void handleArrow(DrawableImage arrow, int x, int color, int color1) {
        ((DrawableImage)((DrawableImage)arrow.dimensions((float)x, 42.0f, 16.0f, 16.0f)).color(color)).texture(this.glowArrowLoc).addChild(DrawableImage::create, subArrow -> ((DrawableImage)((DrawableImage)subArrow.fillParent()).color(color1)).texture(this.arrowFullLoc));
    }

    private void addButton(DrawableFrame panel, int index) {
        panel.addChild(DrawableImage::create, image -> ((DrawableImage)image.texture(locs[index]).dimensions(8.0f, (float)(10 + 24 * index), 22.0f, 22.0f)).padding(6.0f, 6.0f, -6.0f, -6.0f).addChild(DrawableButton::create, button -> ((DrawableButton)((DrawableButton)((DrawableButton)((DrawableButton)button.fillParent()).setColor(DrawableButton.ButtonLayer.Active, -48060).setColor(DrawableButton.ButtonLayer.Hovered, -48060).onClick((widget, x, y, input, action) -> {
            if (input != 0 || action != IClickCallback.Action.Down || ((FabricatorMenu)this.menu).menuData.get(1) == index) {
                return false;
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            XyCore.Network.send((Packet.ServerBound)new SBMenuComponentMessagePacket(1, new byte[]{(byte)index}));
            return true;
        })).onRenderTick((widget, graphics, x1, y1, mouseX, mouseY, depth, time, partialTick) -> widget.setLayer(DrawableButton.ButtonLayer.Active, ((FabricatorMenu)this.menu).menuData.get(1) == index))).onToolTip((widget, mouseX, mouseY, tooltip) -> tooltip.add(Component.translatable((String)buttonDescriptions[index])))).addChild(DrawableBackground::create, bgrnd -> ((DrawableBackground)((DrawableBackground)bgrnd.texture(null).fillParent()).color(-12237499)).onRenderTick((widget, graphics, x1, y1, mouseX, mouseY, depth, time, partialTick) -> {
            if (((FabricatorMenu)this.menu).menuData.get(1) == index) {
                widget.color(-48060);
            } else {
                widget.color(-12237499);
            }
        }))));
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (2 == button) {
            return super.mouseClicked(x, y, button);
        }
        if (this.hoveredSlot != null && this.hoveredSlot.index == 45) {
            if (((FabricatorMenu)this.menu).getCarried().isEmpty()) {
                int i;
                if (ModifierKey.of((Player)Utils.getClientPlayer())) {
                    for (int i2 = this.hoveredSlot.index - 9; i2 < this.hoveredSlot.index; ++i2) {
                        if (!((FabricatorMenu)this.menu).getSlot(i2).hasItem()) continue;
                        XyCore.Network.send((Packet.ServerBound)new SBGhostSlotClickPacket(i2, false, true));
                        ((FabricatorMenu)this.menu).getSlot(i2).setChanged();
                    }
                    return true;
                }
                this.hoveredSlot.set(ItemStack.EMPTY);
                for (i = this.hoveredSlot.index - 9; i <= this.hoveredSlot.index; ++i) {
                    XyCore.Network.send((Packet.ServerBound)new SBGhostSlotClickPacket(i, true, false));
                }
                for (i = this.hoveredSlot.index - 9; i <= this.hoveredSlot.index; ++i) {
                    ((FabricatorMenu)this.menu).getSlot(i).setChanged();
                }
                return true;
            }
            return false;
        }
        return super.mouseClicked(x, y, button);
    }
}

