/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.ui.slots.GhostSlot;
import tv.soaryn.xycraft.machines.content.attachments.FabricatorAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesMenus;

public class FabricatorMenu
extends BaseMenu {
    public final BlockEntity BlockEntity;
    public final ContainerData menuData;
    private final Level _level;

    public FabricatorMenu(int id, Inventory inventory, FriendlyByteBuf data) {
        this(id, inventory, inventory.player.level().getBlockEntity(data.readBlockPos()), (ItemContainer)new SimpleItemContainer(9), (ItemContainer)new SimpleItemContainer(10), (ContainerData)new SimpleContainerData(2));
    }

    public FabricatorMenu(int id, Inventory inventory, BlockEntity entity, ItemContainer inventoryContainer, ItemContainer ghostContainer, ContainerData dataContainer) {
        super(MachinesMenus.Fabricator, id, inventory, null, 200, 192);
        this.menuData = dataContainer;
        FabricatorMenu.checkContainerDataCount((ContainerData)this.menuData, (int)2);
        this.addDataSlots(this.menuData);
        this.BlockEntity = entity;
        this._level = inventory.player.level();
        BaseMenu.Region playerRegion = this.createRegion();
        BaseMenu.Region inventoryRegion = this.createRegion();
        BaseMenu.Region ghostRegion = this.createRegion();
        BaseMenu.Region outputGhostRegion = this.createRegion();
        playerRegion.addShiftTargets(new BaseMenu.RegionHandle[]{inventoryRegion});
        inventoryRegion.addShiftTargets(new BaseMenu.RegionHandle[]{playerRegion.reversed()});
        playerRegion.addPlayerSlots(20, 108, inventory);
        Iterable grid = ghostRegion.addGhostSlots(13, 16, 3, 3, ghostContainer, 0, 1);
        MinecraftServer server = inventory.player.getServer();
        for (GhostSlot ghostSlot : grid) {
            ghostSlot.setStrictContainer(this.menuData, 0);
        }
        outputGhostRegion.addGhostSlot(85, 34, ghostContainer, 9, 64).ghostRendered(false).lock();
        inventoryRegion.addSlots(131, 16, 3, 3, inventoryContainer, 0);
        if (server == null) {
            return;
        }
        CraftingContainer craftingContainer = FabricatorAttachment.createCraftingContainer(ghostContainer, 0);
        RecipeManager recipeManager = server.getRecipeManager();
        inventoryRegion.onChanged(fancySlot -> this.BlockEntity.setChanged());
        ghostRegion.onChanged(slot -> {
            BlockPos pos = this.BlockEntity.getBlockPos();
            BlockState state = this.BlockEntity.getBlockState();
            craftingContainer.setItem(slot.getIndex(), slot.getItem());
            Optional recipe = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingContainer.asCraftInput(), this._level);
            if (recipe.isPresent()) {
                ghostContainer.set(9, ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)craftingContainer.asCraftInput(), (HolderLookup.Provider)this._level.registryAccess()));
            } else {
                ghostContainer.set(9, ItemStack.EMPTY);
            }
            FabricatorAttachment data = (FabricatorAttachment)this.BlockEntity.getData(MachinesAttachments.FabricatorData);
            data.RecipeCache = recipe;
            this.BlockEntity.setChanged();
            this._level.markAndNotifyBlock(pos, this._level.getChunkAt(pos), state, state, 3, 512);
            this._level.sendBlockUpdated(pos, state, state, 11);
            this.broadcastChanges();
        });
    }

    public boolean stillValid(@NotNull Player player) {
        return FabricatorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this._level, (BlockPos)this.BlockEntity.getBlockPos()), (Player)player, (Block)MachinesContent.Block.Fabricator.block());
    }

    public void onMessage(int component, FriendlyByteBuf buf) {
        byte mode = buf.readByte();
        this.menuData.set(1, (int)mode);
        FabricatorAttachment data = (FabricatorAttachment)this.BlockEntity.getData(MachinesAttachments.FabricatorData);
        if (mode == 0 && !data.canCraft()) {
            data.setCanCraft(true);
        }
        this.BlockEntity.setChanged();
        BlockState state = this.BlockEntity.getBlockState();
        BlockPos pos = this.BlockEntity.getBlockPos();
        this._level.setBlockAndUpdate(pos, state);
        this._level.markAndNotifyBlock(pos, this._level.getChunkAt(pos), state, state, 3, 512);
    }
}

