/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.xynergy;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import tv.soaryn.xycraft.api.content.capabilities.ContributionType;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNet;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.api.content.xynergy.XynergyNet;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.event.BlockOnRemoveEvent;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.xynergy.Node;
import tv.soaryn.xycraft.machines.content.xynergy.XynergyNetworkState;
import tv.soaryn.xycraft.machines.network.CBXynergyLaserEdgePacket;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public class XynergyNetGraphLevelAttachment {
    public static final Codec<XynergyNetGraphLevelAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.setOf((Codec)BlockPos.CODEC).fieldOf("node_ids").forGetter(XynergyNetGraphLevelAttachment::nodeIds), (App)CodecUtils.pairOf((Codec)BlockPos.CODEC).listOf().fieldOf("edges").forGetter(XynergyNetGraphLevelAttachment::edges), (App)CodecUtils.tupleOf((Codec)BlockPos.CODEC, Node.CODEC, Object2ObjectOpenHashMap::new).fieldOf("nodes").forGetter(XynergyNetGraphLevelAttachment::nodes), (App)CodecUtils.tupleOf((Codec)CommonCodecs.ChunkPosCodec, (Codec)BlockPos.CODEC.listOf().xmap(ObjectArrayList::new, ObjectArrayList::new), Object2ObjectOpenHashMap::new).fieldOf("chunks").forGetter(XynergyNetGraphLevelAttachment::chunks)).apply((Applicative)builder, XynergyNetGraphLevelAttachment::new));
    public static final AttachmentType.Builder<XynergyNetGraphLevelAttachment> Builder = AttachmentType.builder(XynergyNetGraphLevelAttachment::new).serialize(CODEC);
    final MutableGraph<BlockPos> graph = GraphBuilder.undirected().allowsSelfLoops(false).build();
    final Object2ObjectOpenHashMap<BlockPos, Node> nodeInfoMap = new Object2ObjectOpenHashMap();
    final Object2ObjectOpenHashMap<ChunkPos, ObjectArrayList<BlockPos>> chunkMapping = new Object2ObjectOpenHashMap();
    final ObjectSet<BlockPos> dirtyValues = new ObjectArraySet();
    public XynergyNetworkState state = XynergyNetworkState.Revalidate;

    private XynergyNetGraphLevelAttachment() {
    }

    private XynergyNetGraphLevelAttachment(Set<BlockPos> nodeIds, List<Pair<BlockPos, BlockPos>> edges, Object2ObjectOpenHashMap<BlockPos, Node> nodes, Object2ObjectOpenHashMap<ChunkPos, ObjectArrayList<BlockPos>> chunks) {
        for (BlockPos blockPos : nodeIds) {
            this.graph.addNode((Object)blockPos);
        }
        for (Pair pair : edges) {
            this.graph.putEdge((Object)((BlockPos)pair.getFirst()), (Object)((BlockPos)pair.getSecond()));
        }
        this.nodeInfoMap.putAll(nodes);
        this.chunkMapping.putAll(chunks);
    }

    public void revalidateValuesOverTime(ServerLevel level, int index, int frequency) {
        int chunkCount = this.chunkMapping.size();
        int chunksPerTick = chunkCount / frequency;
        int start = chunksPerTick * index;
        int modded = chunkCount % frequency;
        List<ObjectArrayList<BlockPos>> chunk = this.chunkMapping.values().stream().toList();
        int end = index == frequency - 1 ? start + modded : start + chunksPerTick;
        this.handleNode(level, chunk, start, end);
    }

    private void handleNode(ServerLevel level, List<ObjectArrayList<BlockPos>> chunk, int start, int end) {
        ObjectArraySet toRemove = new ObjectArraySet();
        for (int i = start; i < end; ++i) {
            ObjectArrayList<BlockPos> blockPosList = chunk.get(i);
            if (blockPosList.isEmpty()) continue;
            boolean isLoaded = level.shouldTickBlocksAt((BlockPos)blockPosList.getFirst());
            for (BlockPos pos : blockPosList) {
                boolean removing = false;
                Node node = (Node)this.nodeInfoMap.get((Object)pos);
                if (node == null) {
                    toRemove.add((Object)pos);
                    continue;
                }
                long snapShot = node.Value;
                if (isLoaded) {
                    IXynergyNode xynergyNode = node.getCachedCapability(level, pos);
                    if (xynergyNode != null) {
                        node.Value = xynergyNode.getValue();
                        node.Type = xynergyNode.getPowerType();
                    } else {
                        node.Value = 0L;
                        removing = true;
                        toRemove.add((Object)pos);
                    }
                } else if (node.Type == ContributionType.Active) {
                    node.Value = 0L;
                }
                if (snapShot == node.Value || removing) continue;
                this.dirtyValues.add((Object)pos);
            }
            IXynergyNet net = XynergyNet.of((ServerLevel)level);
            toRemove.forEach(arg_0 -> ((IXynergyNet)net).remove(arg_0));
        }
    }

    public void revalidateValues(ServerLevel level) {
        ObjectArraySet toRemove = new ObjectArraySet();
        for (BlockPos pos : this.graph.nodes()) {
            boolean removing = false;
            Node node = (Node)this.nodeInfoMap.get((Object)pos);
            if (node == null) continue;
            long snapShot = node.Value;
            if (level.shouldTickBlocksAt(pos)) {
                IXynergyNode xynergyNode = node.getCachedCapability(level, pos);
                if (xynergyNode != null) {
                    node.Value = xynergyNode.getValue();
                    node.Type = xynergyNode.getPowerType();
                } else {
                    node.Value = 0L;
                    removing = true;
                    toRemove.add((Object)pos);
                }
            } else {
                switch (node.Type) {
                    case Active: {
                        node.Value = 0L;
                        break;
                    }
                }
            }
            if (snapShot == node.Value || removing) continue;
            this.dirtyValues.add((Object)pos);
        }
    }

    public void cleanValues() {
        ObjectArraySet cleaned = new ObjectArraySet();
        for (BlockPos pos : this.dirtyValues) {
            if (cleaned.contains((Object)pos)) continue;
            cleaned.add((Object)pos);
            Iterable subnet = Traverser.forGraph(this.graph).breadthFirst((Object)pos);
            long sum = 0L;
            for (BlockPos nodePos2 : subnet) {
                cleaned.add((Object)nodePos2);
                Node node = (Node)this.nodeInfoMap.get((Object)nodePos2);
                if (node == null) {
                    XyMachines.Logger.warn("Xynergy net node was `null` when cleaning!");
                    continue;
                }
                if (node.Value > 0L) {
                    sum = MathUtils.longSumUp((long)sum, (long)node.Value);
                    continue;
                }
                sum = MathUtils.longSumLow((long)sum, (long)node.Value);
            }
            long finalSum = Mth.clamp((long)sum, (long)-1000000000000000000L, (long)1000000000000000000L);
            subnet.forEach(nodePos -> {
                Node node = (Node)this.nodeInfoMap.get(nodePos);
                if (node == null) {
                    return;
                }
                node.NetworkedValue = finalSum;
            });
        }
        this.dirtyValues.removeAll((Collection)cleaned);
    }

    @SubscribeEvent
    private static void removeBlockToGraph(BlockOnRemoveEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        IXynergyNet net = XynergyNet.of((ServerLevel)serverLevel);
        if (net == null) {
            return;
        }
        BlockPos pos = event.getPos();
        if (!net.hasNode(pos)) {
            return;
        }
        serverLevel.invalidateCapabilities(pos);
        IXynergyNode nextCap = (IXynergyNode)serverLevel.getCapability(CoreCapabilities.XynergyNode.BLOCK, pos, event.getNextState(), null, null);
        if (nextCap == null) {
            net.remove(pos);
        } else {
            XynergyNetGraphLevelAttachment data = (XynergyNetGraphLevelAttachment)serverLevel.getData(MachinesAttachments.XynergyNetData);
            Node node = (Node)data.nodeInfoMap.get((Object)pos);
            if (node != null) {
                node.Type = nextCap.getPowerType();
            }
        }
    }

    @SubscribeEvent
    public static void onChunkWatchWatch(ChunkWatchEvent.Sent event) {
        XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)event.getLevel().getData(MachinesAttachments.XynergyNetData);
        ObjectArrayList nodes = (ObjectArrayList)net.chunkMapping.get((Object)event.getPos());
        if (nodes == null) {
            return;
        }
        for (BlockPos pos : nodes) {
            for (BlockPos endPos : net.graph.adjacentNodes((Object)pos)) {
                XyMachines.Network.send((Player)event.getPlayer(), (Packet.ClientBound)new CBXynergyLaserEdgePacket(pos.asLong(), endPos.asLong(), true));
            }
        }
    }

    private static Set<BlockPos> nodeIds(XynergyNetGraphLevelAttachment net) {
        return net.graph.nodes();
    }

    private static List<Pair<BlockPos, BlockPos>> edges(XynergyNetGraphLevelAttachment net) {
        return net.graph.edges().stream().map(longs -> Pair.of((Object)((BlockPos)longs.nodeU()), (Object)((BlockPos)longs.nodeV()))).collect(Collectors.toList());
    }

    private static Object2ObjectOpenHashMap<BlockPos, Node> nodes(XynergyNetGraphLevelAttachment xynergyNet) {
        return xynergyNet.nodeInfoMap;
    }

    private static Object2ObjectOpenHashMap<ChunkPos, ObjectArrayList<BlockPos>> chunks(XynergyNetGraphLevelAttachment xynergyNet) {
        return xynergyNet.chunkMapping;
    }
}

