/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.InventoryAttachment;
import tv.soaryn.xycraft.machines.content.attachments.level.ProducerTickSystemLevelAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.systems.multiblocks.ProducerTickSystem;

public class SmelterTickSystem
extends ProducerTickSystem<SmeltingRecipe, SingleRecipeInput> {
    public static final Codec<ProducerTickSystemLevelAttachment<SmeltingRecipe, SingleRecipeInput>> CODEC = RecordCodecBuilder.create(builder -> ProducerTickSystemLevelAttachment.producerGroup(builder).apply((Applicative)builder, (chunkMap, frequency, enabled) -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)chunkMap, (long)frequency, (boolean)enabled, RecipeType.SMELTING)));
    public static final AttachmentType.Builder<ProducerTickSystemLevelAttachment<SmeltingRecipe, SingleRecipeInput>> Builder = AttachmentType.builder(() -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap(), 10L, true, RecipeType.SMELTING)).serialize(CODEC);

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        throw new NotImplementedException();
    }

    protected void tickBlocks(ServerLevel level, ProducerTickSystemLevelAttachment<SmeltingRecipe, SingleRecipeInput> tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        SmeltingRecipe recipe = this.getRecipe(level, tickData, (BlockPos)pos, state, currentStep);
        if (recipe == null) {
            return;
        }
        InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity((BlockPos)pos)).getData(MachinesAttachments.SoarynBoxData);
        ItemStack itemInSlot = data.getInventory().get(0);
        itemInSlot.shrink(1);
        ItemStack out = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        if (out.isEmpty()) {
            return;
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)data.Inventory.asHandler(), (ItemStack)out, (boolean)false);
    }

    @NotNull
    protected Supplier<AttachmentType<ProducerTickSystemLevelAttachment<SmeltingRecipe, SingleRecipeInput>>> getAttachmentType() {
        return MachinesAttachments.SmelterSystemData;
    }

    @Override
    public SingleRecipeInput getInput(ServerLevel level, ProducerTickSystemLevelAttachment<SmeltingRecipe, SingleRecipeInput> tickData, BlockPos pos, BlockState state, long currentStep) {
        InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity(pos)).getData(MachinesAttachments.SoarynBoxData);
        return new SingleRecipeInput(data.getInventory().get(0));
    }

    @Override
    public long getTimeRequired(SmeltingRecipe recipe) {
        return (long)recipe.getCookingTime() * 3L / 4L;
    }
}

