/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class FluidPipeExtractionSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.PipeFluid.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.PipeFluid.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Fluid Extraction Pipe at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        IPipeConnection extractor = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, (BlockPos)pos, null);
        if (extractor == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            int simulatedFill;
            IFluidHandler pipeCap;
            FluidStack simulatedDrain;
            IFluidHandler otherCap;
            PipeConnectionType logic;
            if (extractor.isClosed(dir) || (logic = extractor.getLogic(dir)) != PipeConnectionType.Extract || (otherCap = CapAccess.fluid((BlockEntity)blockEntity, (Direction)dir)) == null || (simulatedDrain = otherCap.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || (pipeCap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, (BlockPos)pos, (Object)dir)) == null || (simulatedFill = pipeCap.fill(simulatedDrain, IFluidHandler.FluidAction.SIMULATE)) == 0) continue;
            FluidStack actualDrain = otherCap.drain(simulatedFill, IFluidHandler.FluidAction.EXECUTE);
            pipeCap.fill(actualDrain, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.FluidPipeExtractionSystemData;
    }
}

