/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.core.utils.BitFlagUtils;
import tv.soaryn.xycraft.core.utils.FakePlayerUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.FabricatorAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class FabricatorTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.Fabricator.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.Fabricator.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Fabricator at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }

    protected void tickBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        super.tickBlocks(level, tickData, pos, state, currentStep);
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        FabricatorAttachment data = (FabricatorAttachment)blockEntity.getData(MachinesAttachments.FabricatorData);
        int mode = data.MenuData.get(1);
        if (mode == 0) {
            return;
        }
        boolean canCraftNow = data.canCraft();
        boolean hasSignal = level.hasNeighborSignal((BlockPos)pos);
        boolean prevState = data.prevRedstoneState();
        if (prevState != hasSignal) {
            data.setPrevRedstoneState(hasSignal);
            blockEntity.setChanged();
        }
        switch (mode) {
            case 1: {
                if (hasSignal && !canCraftNow) {
                    data.setCanCraft(true);
                    blockEntity.setChanged();
                    level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                    break;
                }
                if (hasSignal || !canCraftNow) break;
                data.setCanCraft(false);
                blockEntity.setChanged();
                level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                break;
            }
            case 2: {
                long processingTime = (Long)blockEntity.getData(CoreAttachments.ProcessTime);
                if (processingTime > 0L) {
                    blockEntity.setData(CoreAttachments.ProcessTime, (Object)(processingTime - 1L));
                }
                if (processingTime == 0L && canCraftNow) {
                    data.setCanCraft(false);
                    blockEntity.setChanged();
                    level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                    return;
                }
                if (prevState == hasSignal) {
                    return;
                }
                if (canCraftNow || !hasSignal || processingTime != 0L) break;
                blockEntity.setData(CoreAttachments.ProcessTime, (Object)4L);
                if (!this.tryCraft(level, data, state, blockEntity, (BlockPos)pos)) {
                    return;
                }
                data.setCanCraft(true);
                blockEntity.setChanged();
                level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                break;
            }
        }
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        FabricatorAttachment data = (FabricatorAttachment)blockEntity.getData(MachinesAttachments.FabricatorData);
        data.invalidateRecipeCache();
        int mode = data.MenuData.get(1);
        boolean canCraftNow = data.canCraft();
        if (!canCraftNow || mode == 2) {
            return;
        }
        this.tryCraft(level, data, state, blockEntity, (BlockPos)pos);
    }

    private boolean tryCraft(ServerLevel level, FabricatorAttachment data, BlockState state, BlockEntity blockEntity, BlockPos pos) {
        int i;
        int ghostSlot;
        if (data.RecipeCache.isEmpty()) {
            return false;
        }
        RecipeHolder<CraftingRecipe> recipe = data.RecipeCache.get();
        CraftingContainer sandboxCrafting = FabricatorAttachment.createCraftingContainer(data.Ghost, 0);
        CraftingContainer finalCrafting = FabricatorAttachment.createCraftingContainer((ItemContainer)new SimpleItemContainer(9), 0);
        int strictFlag = data.MenuData.get(0);
        ArrayList<IItemHandler> itemHandlers = new ArrayList<IItemHandler>();
        itemHandlers.add(data.ItemHandler);
        Direction.stream().filter(Predicate.not(arg_0 -> ((Direction)state.getValue((Property)CoreStateProperties.StateDirection)).equals(arg_0))).filter(direction -> !level.getBlockState(pos.relative(direction)).is(XyCraftTags.Blocks.FabricatorIgnore.tag())).map(direction -> CapAccess.item((BlockEntity)blockEntity, (Direction)direction)).filter(Objects::nonNull).forEach(itemHandlers::add);
        ArrayList<CraftingIngredient> listOfIngredients = new ArrayList<CraftingIngredient>(9);
        block0: for (ghostSlot = 0; ghostSlot < 9; ++ghostSlot) {
            FabricatorAttachment.resetCraftingSandbox(sandboxCrafting, data.Ghost);
            if (sandboxCrafting.getItem(ghostSlot).isEmpty() || !BitFlagUtils.getAccess((int)strictFlag, (int)((byte)ghostSlot))) continue;
            for (IItemHandler handler : itemHandlers) {
                if (!this.findInput((Level)level, (CraftingRecipe)recipe.value(), sandboxCrafting, finalCrafting, listOfIngredients, handler, ghostSlot, strictFlag)) continue;
                continue block0;
            }
        }
        block2: for (ghostSlot = 0; ghostSlot < 9; ++ghostSlot) {
            FabricatorAttachment.resetCraftingSandbox(sandboxCrafting, data.Ghost);
            if (sandboxCrafting.getItem(ghostSlot).isEmpty() || BitFlagUtils.getAccess((int)strictFlag, (int)((byte)ghostSlot))) continue;
            for (IItemHandler handler : itemHandlers) {
                if (!this.findInput((Level)level, (CraftingRecipe)recipe.value(), sandboxCrafting, finalCrafting, listOfIngredients, handler, ghostSlot, strictFlag)) continue;
                continue block2;
            }
        }
        int finalIngredientCount = 0;
        int intendedIngredientCount = 0;
        for (i = 0; i < finalCrafting.getContainerSize(); ++i) {
            if (finalCrafting.getItem(i).isEmpty()) continue;
            ++finalIngredientCount;
        }
        for (i = 0; i < data.Ghost.size() - 1; ++i) {
            if (data.Ghost.get(i).isEmpty()) continue;
            ++intendedIngredientCount;
        }
        return intendedIngredientCount == finalIngredientCount && ((CraftingRecipe)recipe.value()).matches((RecipeInput)finalCrafting.asCraftInput(), (Level)level) && this.craft(level, data, (CraftingRecipe)recipe.value(), finalCrafting, listOfIngredients);
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.FabricatorSystemData;
    }

    private boolean findInput(Level level, CraftingRecipe recipe, CraftingContainer sandbox, CraftingContainer finalCrafting, List<CraftingIngredient> currentIngredients, IItemHandler handler, int ghostSlot, int strictFlag) {
        ItemStack specificItemStack = sandbox.getItem(ghostSlot).copy();
        boolean isSpecific = BitFlagUtils.getAccess((int)strictFlag, (int)((byte)ghostSlot));
        for (int inventorySlot = handler.getSlots() - 1; inventorySlot >= 0; --inventorySlot) {
            ItemStack remainder;
            int amountNeededFromSlot = 1;
            for (CraftingIngredient existing : currentIngredients) {
                if (existing.slot != inventorySlot || handler != existing.handler) continue;
                ++amountNeededFromSlot;
            }
            ItemStack inputStack = handler.extractItem(inventorySlot, amountNeededFromSlot, true).copy();
            if (inputStack.isEmpty() || inputStack.getCount() < amountNeededFromSlot || inputStack.hasCraftingRemainingItem() && !(remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)inputStack.getCraftingRemainingItem(), (boolean)true)).isEmpty()) continue;
            inputStack.setCount(1);
            if (isSpecific && !ItemStack.matches((ItemStack)specificItemStack, (ItemStack)inputStack)) continue;
            sandbox.setItem(ghostSlot, inputStack);
            CraftingInput craftInput = sandbox.asCraftInput();
            if (!recipe.matches((RecipeInput)craftInput, level) || ItemStack.matches((ItemStack)recipe.assemble((RecipeInput)craftInput, (HolderLookup.Provider)level.registryAccess()), (ItemStack)inputStack) && !isSpecific) continue;
            currentIngredients.add(new CraftingIngredient(handler, inputStack, inventorySlot));
            finalCrafting.setItem(ghostSlot, inputStack);
            return true;
        }
        return false;
    }

    private boolean craft(ServerLevel level, FabricatorAttachment data, CraftingRecipe recipe, CraftingContainer finalCrafting, ArrayList<CraftingIngredient> listOfIngredients) {
        int o;
        int n;
        ArrayList<IItemHandler> usedHandlers = new ArrayList<IItemHandler>();
        ArrayList<ItemStack> remainingItemList = new ArrayList<ItemStack>();
        for (CraftingIngredient ingredient : listOfIngredients) {
            if (!usedHandlers.contains(ingredient.handler)) {
                usedHandlers.add(ingredient.handler);
            }
            if (!ingredient.inputStack.hasCraftingRemainingItem()) continue;
            remainingItemList.add(ingredient.inputStack.getCraftingRemainingItem());
        }
        CraftingInput craftInput = finalCrafting.asCraftInput();
        ItemStack output = recipe.assemble((RecipeInput)craftInput, (HolderLookup.Provider)level.registryAccess());
        SimpleItemContainer sandboxInventory = new SimpleItemContainer(9);
        for (int i = 0; i < sandboxInventory.size(); ++i) {
            sandboxInventory.set(i, data.Storage.get(i).copy());
        }
        ArrayList<ItemStack> copyOfRemainders = new ArrayList<ItemStack>((Collection<ItemStack>)recipe.getRemainingItems((RecipeInput)craftInput));
        copyOfRemainders.removeIf(ItemStack::isEmpty);
        List<ItemStack> extraRemainders = remainingItemList.stream().filter(copyOfRemainders::contains).toList();
        IItemHandlerModifiable sandboxHandle = sandboxInventory.asHandler();
        Integer[] internalItemsNeeded = (Integer[])listOfIngredients.stream().filter(craftingIngredient -> craftingIngredient.handler() == data.ItemHandler).map(CraftingIngredient::slot).toArray(Integer[]::new);
        Object object = internalItemsNeeded;
        int n2 = ((Integer[])object).length;
        for (n = 0; n < n2; ++n) {
            o = object[n];
            sandboxHandle.extractItem(o, 1, false);
        }
        object = internalItemsNeeded;
        n2 = ((Integer[])object).length;
        for (n = 0; n < n2; ++n) {
            IItemHandler inventoryHandler = data.ItemHandler;
            o = object[n];
            ItemStack testStack = inventoryHandler.extractItem(o, 1, true);
            if (!testStack.hasCraftingRemainingItem() || ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)testStack.getCraftingRemainingItem(), (boolean)false).isEmpty()) continue;
            return false;
        }
        for (ItemStack remainder : extraRemainders) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)remainder.copy(), (boolean)false).isEmpty()) continue;
            return false;
        }
        if (!ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)output.copy(), (boolean)false).isEmpty()) {
            return false;
        }
        output.onCraftedBySystem((Level)level);
        PlayerEvent.ItemCraftedEvent eventStruct = new PlayerEvent.ItemCraftedEvent(FakePlayerUtils.getFakePlayer((ServerLevel)level, (UUID)data.playerId()), output, (Container)finalCrafting);
        NeoForge.EVENT_BUS.post((Event)eventStruct);
        output.onCraftedBySystem((Level)level);
        for (CraftingIngredient ingredient : listOfIngredients) {
            ItemStack extracted = ingredient.handler.extractItem(ingredient.slot, 1, false);
            if (!extracted.hasCraftingRemainingItem()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)ingredient.handler, (ItemStack)extracted.getCraftingRemainingItem(), (boolean)false);
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)data.ItemHandler, (ItemStack)output, (boolean)false);
        for (ItemStack extraRemainder : extraRemainders) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)data.ItemHandler, (ItemStack)extraRemainder, (boolean)false);
        }
        return true;
    }

    private record CraftingIngredient(IItemHandler handler, ItemStack inputStack, int slot) {
    }
}

