/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.ProcessingDataAttachment;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.ExtractorAttachment;
import tv.soaryn.xycraft.machines.content.blocks.extractor.ExtractorBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class ExtractorTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.Extractor.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.Extractor.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Extractor at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }

    protected void tickBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        ItemStack stack;
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        long currentTime = (Long)blockEntity.getData(CoreAttachments.ProcessTime);
        ProcessingDataAttachment data = (ProcessingDataAttachment)blockEntity.getData(CoreAttachments.ProcessingData);
        MachineStatusColors status = (MachineStatusColors)((Object)state.getValue(MachineStateProperties.Status));
        boolean hasSignal = level.hasNeighborSignal((BlockPos)pos);
        if (hasSignal && status != MachineStatusColors.Off) {
            state = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Off));
            level.setBlockAndUpdate((BlockPos)pos, state);
            return;
        }
        if (!hasSignal && status == MachineStatusColors.Off) {
            MachineStatusColors newStatus = status;
            if (data.RecipeCache.isPresent()) {
                ExtractorAttachment extractorData = (ExtractorAttachment)blockEntity.getData(MachinesAttachments.ExtractorData);
                Recipe recipe = ((RecipeHolder)data.RecipeCache.get()).value();
                if (recipe instanceof ExtractorRecipe) {
                    ExtractorRecipe recipe2 = (ExtractorRecipe)recipe;
                    if (recipe2.isFluidRecipe()) {
                        newStatus = extractorData.Tank.getFluidAmount() < extractorData.Tank.getCapacity() ? MachineStatusColors.Success : MachineStatusColors.Idle;
                        state = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)newStatus));
                    } else {
                        stack = extractorData.Items.get(0);
                        ItemStack inserted = ItemHandlerHelper.insertItemStacked((IItemHandler)extractorData.Items.asHandler(), (ItemStack)recipe2.getItemOutput(), (boolean)true);
                        newStatus = stack.isEmpty() || recipe2.getItemOutput().getCount() != inserted.getCount() ? MachineStatusColors.Success : (stack.getCount() != ItemHandlerHelper.insertItemStacked((IItemHandler)CapAccess.item((BlockEntity)blockEntity, (Direction)SidePartBlock.directionOf((BlockState)state).getOpposite()), (ItemStack)stack, (boolean)true).getCount() ? MachineStatusColors.Success : MachineStatusColors.Idle);
                    }
                }
            } else {
                newStatus = MachineStatusColors.Error;
            }
            if (newStatus != status) {
                status = newStatus;
                level.setBlockAndUpdate((BlockPos)pos, (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)status)));
            }
        }
        if (status == MachineStatusColors.Idle || status == MachineStatusColors.Off || status == MachineStatusColors.Error || data.RecipeCache.isEmpty()) {
            return;
        }
        long newTime = Math.max(currentTime - 1L, 0L);
        if (newTime == currentTime) {
            return;
        }
        if (newTime != 0L) {
            blockEntity.setData(CoreAttachments.ProcessTime, (Object)newTime);
            return;
        }
        blockEntity.setData(CoreAttachments.ProcessTime, (Object)data.TimeRequired);
        if (data.RecipeCache.isEmpty() || !((stack = ((RecipeHolder)data.RecipeCache.get()).value()) instanceof ExtractorRecipe)) {
            return;
        }
        ExtractorRecipe extractorRecipe = (ExtractorRecipe)stack;
        ExtractorAttachment extractorData = (ExtractorAttachment)blockEntity.getData(MachinesAttachments.ExtractorData);
        if (extractorRecipe.isFluidRecipe()) {
            FluidStack fluidResult = extractorRecipe.getFluidOutput();
            int filled = extractorData.Tank.fill(fluidResult, IFluidHandler.FluidAction.SIMULATE);
            if (filled == fluidResult.getAmount()) {
                extractorData.Tank.fill(fluidResult, IFluidHandler.FluidAction.EXECUTE);
                blockEntity.setChanged();
            } else {
                level.setBlockAndUpdate((BlockPos)pos, (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Idle)));
            }
        } else {
            ItemStack itemResult = extractorRecipe.getItemOutput();
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)extractorData.Items.asHandler(), (ItemStack)itemResult, (boolean)true);
            if (remainder.isEmpty()) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)extractorData.Items.asHandler(), (ItemStack)itemResult, (boolean)false);
                blockEntity.setChanged();
            } else {
                level.setBlockAndUpdate((BlockPos)pos, (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Idle)));
            }
        }
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (!(blockEntity instanceof ExtractorBlockEntity)) {
            return;
        }
        ExtractorBlockEntity extractor = (ExtractorBlockEntity)blockEntity;
        ProcessingDataAttachment data = (ProcessingDataAttachment)extractor.getData(CoreAttachments.ProcessingData);
        ExtractorAttachment.checkForValidRecipe(level, (BlockPos)pos, state, extractor, data);
        ExtractorAttachment extractorData = (ExtractorAttachment)blockEntity.getData(MachinesAttachments.ExtractorData);
        MachineStatusColors status = (MachineStatusColors)((Object)state.getValue(MachineStateProperties.Status));
        if (status == MachineStatusColors.Off) {
            return;
        }
        if (data.RecipeCache.isEmpty()) {
            if (status != MachineStatusColors.Error) {
                state = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Error));
                level.setBlockAndUpdate((BlockPos)pos, state);
            }
            return;
        }
        Recipe recipe = ((RecipeHolder)data.RecipeCache.get()).value();
        if (!(recipe instanceof ExtractorRecipe)) {
            return;
        }
        ExtractorRecipe extractorRecipe = (ExtractorRecipe)recipe;
        if (extractorRecipe.isFluidRecipe()) {
            ExtractorTickSystem.handleFluidRecipe(level, (BlockPos)pos, state, extractor, extractorData, status);
        } else {
            ExtractorTickSystem.handleItemRecipe(level, (BlockPos)pos, state, extractor, extractorData, status);
        }
    }

    private static void handleFluidRecipe(ServerLevel level, BlockPos pos, BlockState state, ExtractorBlockEntity extractor, ExtractorAttachment extractorData, MachineStatusColors status) {
        FluidStack drained;
        IFluidHandler fluidHandler = CapAccess.fluid((BlockEntity)extractor, (Direction)SidePartBlock.directionOf((BlockState)state).getOpposite());
        BlockState newState = state;
        if (state.getValue(MachineStateProperties.IOMode) != IOMode.Fluid) {
            newState = (BlockState)newState.setValue(MachineStateProperties.IOMode, (Comparable)((Object)IOMode.Fluid));
        }
        if (fluidHandler != null && !extractorData.Tank.isEmpty() && !(drained = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)extractorData.Tank, (int)extractorData.Tank.getFluidAmount(), (boolean)true)).isEmpty()) {
            extractor.setChanged();
        }
        if (state != (newState = (BlockState)newState.setValue(MachineStateProperties.Status, (Comparable)((Object)(extractorData.Tank.getSpace() == 0 ? MachineStatusColors.Idle : MachineStatusColors.Success))))) {
            level.setBlockAndUpdate(pos, newState);
        }
    }

    private static void handleItemRecipe(ServerLevel level, BlockPos pos, BlockState state, ExtractorBlockEntity extractor, ExtractorAttachment extractorData, MachineStatusColors status) {
        IItemHandler itemHandler = CapAccess.item((BlockEntity)extractor, (Direction)SidePartBlock.directionOf((BlockState)state).getOpposite());
        BlockState newState = state;
        if (state.getValue(MachineStateProperties.IOMode) != IOMode.Item) {
            newState = (BlockState)newState.setValue(MachineStateProperties.IOMode, (Comparable)((Object)IOMode.Item));
        }
        ItemStack stackInBuffer = extractorData.Items.get(0).copy();
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stackInBuffer.copy(), (boolean)false);
        extractorData.Items.set(0, remainder);
        extractor.setChanged();
        boolean hasSpace = !stackInBuffer.isEmpty() && stackInBuffer.getCount() == stackInBuffer.getMaxStackSize();
        newState = (BlockState)newState.setValue(MachineStateProperties.Status, (Comparable)((Object)(!hasSpace ? MachineStatusColors.Success : MachineStatusColors.Idle)));
        if (state != newState) {
            level.setBlockAndUpdate(pos, newState);
        }
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.ExtractorSystemData;
    }
}

