/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.hydropump;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.handlers.InfiniteFluidHandler;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class HydroPumpBlock
extends SidePartBlock.WithEntity
implements IColoredBlock,
EntityBlock,
ITooltipProvider {
    public HydroPumpBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().randomTicks(), Entity::new);
        this.registerSystem(MachinesSystems.HydroPump);
        this.registerHasCapability();
    }

    public void appendToolTip(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)this.getToolTipKey(0)).withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.translatable((String)this.getToolTipKey(1)).withStyle(ChatFormatting.GRAY));
        if (ModifierKey.ofClient()) {
            components.add((Component)Component.translatable((String)this.getToolTipKey(2), (Object[])new Object[]{String.valueOf(XyMachines.ServerConfig.HydroPumpFluidAmount.get())}).withColor(-5592321));
            components.add((Component)Component.translatable((String)this.getToolTipKey(3), (Object[])new Object[]{String.valueOf(XyMachines.ServerConfig.HydroPumpFluidAmountWaterLogged.get())}).withColor(-5592321));
        }
    }

    public VoxelShape getDownShapeForBaking() {
        return Shapes.or((VoxelShape)HydroPumpBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, blockEntity, context) -> context == state.getValue((Property)CoreStateProperties.StateDirection) ? new InfiniteFluidHandler((Fluid)Fluids.WATER) : null, new Block[]{MachinesContent.Block.HydroPump.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.HydroPump.block()});
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        if (index == 2) {
            IClientFluidTypeExtensions fluid = IClientFluidTypeExtensions.of((Fluid)Fluids.WATER);
            return level != null ? fluid.getTintColor(Fluids.WATER.defaultFluidState(), level, pos) : fluid.getTintColor();
        }
        return super.getColorOfBlock(state, level, pos, index);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index == 2) {
            return IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getTintColor(Fluids.WATER.defaultFluidState(), (BlockAndTintGetter)Utils.getClientLevel(), Utils.getClientPlayer().blockPosition());
        }
        return index != 0 ? XyCraftColors.Blue.getColor() : -1;
    }

    public static class Entity
    extends XyBlockEntity {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.HydroPump.entity(), pos, state, new AttachmentType[0]);
        }
    }
}

