/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class PlanterBlock
extends ColoredBlock {
    public PlanterBlock(BlockBehaviour.Properties properties) {
        super((IColorSource)XyCraftColors.Green, properties.randomTicks());
        this.defaultBlockState().setValue((Property)CoreStateProperties.StateDirection, (Comparable)Direction.UP);
        this.registerSystem(MachinesSystems.Planter);
        this.registerHasCapability();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CoreStateProperties.StateDirection});
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ModifierKey.of((Player)ctx.getPlayer()) ? ctx.getClickedFace().getOpposite() : ctx.getClickedFace();
        return (BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.StateDirection, (Comparable)direction);
    }

    @SubscribeEvent
    private static void attachCapability(RegisterCapabilitiesEvent event) {
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.Planter.block()});
    }

    public boolean isFertile(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public TriState canSustainPlant(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull BlockState plantable) {
        return facing == state.getValue((Property)CoreStateProperties.StateDirection) ? TriState.TRUE : TriState.DEFAULT;
    }
}

