/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.fluid.FluidTankProxy;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.attachments.ProcessingDataAttachment;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.blocks.extractor.ExtractorBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public class ExtractorAttachment
implements CommonCodecs.IItemContainerHolder {
    public static final Codec<ExtractorAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("target").forGetter(ExtractorAttachment::getTargetPos), (App)BlockPos.CODEC.fieldOf("catalyst").forGetter(ExtractorAttachment::getCatalystPos), (App)BlockPos.CODEC.listOf().fieldOf("adjacent").forGetter(ExtractorAttachment::getAdjacentPos), (App)CommonCodecs.recordCodec((String)"inventory"), (App)CodecUtils.Codecs.FLUID_STACK_OPTIONAL.fieldOf("fluid").forGetter(data -> data.Tank.getFluid())).apply((Applicative)builder, ExtractorAttachment::new));
    public static final AttachmentType.Builder<ExtractorAttachment> BUILDER = AttachmentUtils.createBuilder(ExtractorAttachment::new, CODEC, ExtractorAttachment::setHolder);
    private BlockPos _targetPos;
    private BlockPos _catalystPos;
    private List<BlockPos> _adjacentPos;
    public final ItemContainer Items = new SimpleItemContainer(1, this::setChanged);
    public final IItemHandler ItemHandler = this.Items.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
    public final FluidTank Tank;
    public final FluidTankProxy FluidHandler;
    private BlockEntity _blockEntity;

    private ExtractorAttachment(IAttachmentHolder holder) {
        this(BlockPos.ZERO, BlockPos.ZERO, List.of(), List.of(), FluidStack.EMPTY);
        this.setHolder(holder);
    }

    private ExtractorAttachment(BlockPos target, BlockPos catalystPos, List<BlockPos> adjPos, List<ItemStack> items, FluidStack fluidStack) {
        this.setTargetPos(target);
        this.setCatalystPos(catalystPos);
        this.setAdjacentPos(adjPos);
        for (int i = 0; i < items.size(); ++i) {
            this.Items.set(i, items.get(i));
        }
        this.Tank = new FluidTank(((Integer)XyMachines.ServerConfig.ExtractorInternalBufferSize.get()).intValue());
        this.Tank.setFluid(fluidStack);
        this.FluidHandler = new FluidTankProxy(this, this.Tank){

            public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
                return 0;
            }

            public boolean isFluidValid(@NotNull FluidStack stack) {
                return false;
            }
        };
    }

    public void setHolder(IAttachmentHolder holder) {
        this._blockEntity = (BlockEntity)holder;
    }

    private void setChanged() {
        if (this._blockEntity != null) {
            this._blockEntity.setChanged();
        }
    }

    public static void checkForValidRecipe(ServerLevel level, BlockPos pos, BlockState state, ExtractorBlockEntity container, ProcessingDataAttachment data) {
        List recipeList = level.getRecipeManager().getAllRecipesFor((RecipeType)MachinesRecipeTypes.Extractor.type().get());
        ResourceLocation currentId = data.RecipeCache.isPresent() ? ((RecipeHolder)data.RecipeCache.get()).id() : Optional.empty();
        recipeList.stream().filter(holder -> ((ExtractorRecipe)holder.value()).catalyst().isPresent()).filter(holder -> ((ExtractorRecipe)holder.value()).matches(container, (Level)level)).max(ExtractorAttachment::compareAdjacentCounts).ifPresentOrElse(recipeHolder -> ExtractorAttachment.setRecipe(level, pos, state, (BlockEntity)container, data, (RecipeHolder<? extends ExtractorRecipe>)recipeHolder), () -> recipeList.stream().filter(holder -> ((ExtractorRecipe)holder.value()).catalyst().isEmpty()).filter(recipe -> ((ExtractorRecipe)recipe.value()).matches(container, (Level)level)).max(ExtractorAttachment::compareAdjacentCounts).ifPresentOrElse(recipeHolder -> ExtractorAttachment.setRecipe(level, pos, state, (BlockEntity)container, data, (RecipeHolder<? extends ExtractorRecipe>)recipeHolder), () -> ExtractorAttachment.resetRecipe((BlockEntity)container, data)));
        if (data.RecipeCache.isPresent() && currentId != ((RecipeHolder)data.RecipeCache.get()).id()) {
            ((ExtractorAttachment)container.getData(MachinesAttachments.ExtractorData)).Items.clear();
        }
    }

    public static int compareAdjacentCounts(RecipeHolder<? extends ExtractorRecipe> r1, RecipeHolder<? extends ExtractorRecipe> r2) {
        return Integer.compare(((ExtractorRecipe)r2.value()).adjacentRules().size(), ((ExtractorRecipe)r1.value()).adjacentRules().size());
    }

    public static void setRecipe(ServerLevel level, BlockPos pos, BlockState state, BlockEntity blockEntity, ProcessingDataAttachment data, RecipeHolder<? extends ExtractorRecipe> recipeHolder) {
        IOMode target;
        if (data.RecipeCache.isPresent() && recipeHolder.id().equals((Object)((RecipeHolder)data.RecipeCache.get()).id())) {
            return;
        }
        data.RecipeId = Optional.of(recipeHolder.id());
        data.RecipeCache = Optional.of(recipeHolder);
        data.TimeRequired = ((ExtractorRecipe)recipeHolder.value()).ticks();
        blockEntity.setChanged();
        blockEntity.setData(CoreAttachments.ProcessTime, (Object)data.TimeRequired);
        IOMode iOMode = target = ((ExtractorRecipe)recipeHolder.value()).isFluidRecipe() ? IOMode.Fluid : IOMode.Item;
        if (target == state.getValue(MachineStateProperties.IOMode)) {
            return;
        }
        BlockState newState = (BlockState)state.setValue(MachineStateProperties.IOMode, (Comparable)((Object)target));
        level.setBlockAndUpdate(pos, newState);
        level.markAndNotifyBlock(pos, level.getChunkAt(pos), newState, newState, 3, 512);
    }

    private static void resetRecipe(BlockEntity blockEntity, ProcessingDataAttachment data) {
        data.RecipeCache = Optional.empty();
        data.RecipeId = Optional.empty();
        data.TimeRequired = 0L;
        data.IsBuffered = false;
        blockEntity.setData(CoreAttachments.ProcessTime, (Object)0L);
        blockEntity.setChanged();
    }

    public BlockPos getTargetPos() {
        return this._targetPos;
    }

    public void setTargetPos(BlockPos targetPos) {
        this._targetPos = targetPos;
    }

    public BlockPos getCatalystPos() {
        return this._catalystPos;
    }

    public void setCatalystPos(BlockPos catalystPos) {
        this._catalystPos = catalystPos;
    }

    public List<BlockPos> getAdjacentPos() {
        return this._adjacentPos;
    }

    public void setAdjacentPos(List<BlockPos> adjacentPos) {
        this._adjacentPos = adjacentPos;
    }

    public ItemContainer getInventory() {
        return this.Items;
    }
}

