/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render.instanced;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;
import tv.soaryn.xycraft.core.client.shader.CoreRenderTypes;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.render.MachinesModelBakery;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class InstancedIcosphere {
    private static int VertexData;
    public static int VertCount;
    private static final Object2ObjectMap<SectionPos, DrawBatch> drawBatches;

    public static void startup() {
        if (VertexData != 0) {
            return;
        }
        VertexData = GL33C.glGenBuffers();
        RenderType renderType = CoreRenderTypes.icosphere((ResourceLocation)XyMachines.resource("textures/block/xynergy_core.png"));
        VertexDataBuilder vertexDataBuilder = new VertexDataBuilder();
        MachinesModelBakery.Icosphere.render(new PoseStack(), vertexDataBuilder, renderType, 0, 0);
        VertCount = vertexDataBuilder.vertIndex * 6 / 4;
        BufferUploader.invalidate();
        GL33C.glBindBuffer((int)34962, (int)VertexData);
        GL33C.glBufferData((int)34962, (ByteBuffer)vertexDataBuilder.byteBuffer, (int)35044);
        GL33C.glBindBuffer((int)34962, (int)0);
    }

    public static void shutdown() {
        if (VertexData == 0) {
            return;
        }
        InstancedIcosphere.clear();
        GL33C.glDeleteBuffers((int)VertexData);
        VertexData = 0;
    }

    public static void clear() {
        for (DrawBatch batch : drawBatches.values()) {
            batch.cleanup();
        }
        drawBatches.clear();
    }

    @SubscribeEvent
    public static void stopLevel(LevelEvent.Unload event) {
        if (!event.getLevel().isClientSide()) {
            return;
        }
        InstancedIcosphere.clear();
    }

    public static void addSphere(SphereData data) {
        InstancedIcosphere.startup();
        SectionPos sectionPos = SectionPos.of((BlockPos)data.pos);
        DrawBatch drawBatch = (DrawBatch)drawBatches.computeIfAbsent((Object)sectionPos, _pos -> new DrawBatch());
        drawBatch.add(data);
    }

    public static void removeSphere(SphereData data) {
        SectionPos sectionPos = SectionPos.of((BlockPos)data.pos);
        DrawBatch drawBatch = (DrawBatch)drawBatches.get((Object)sectionPos);
        if (drawBatch != null) {
            drawBatch.remove(data);
        }
    }

    public static void draw(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        InstancedIcosphere.startup();
        BufferUploader.invalidate();
        ShaderInstance shader = CoreRenderTypes.Internal.icosphereShader;
        Uniform SpinMatrix = shader.getUniform("SpinMatrix");
        Uniform ModelViewMat = shader.getUniform("ModelViewMat");
        Uniform ProjMat = shader.getUniform("ProjMat");
        Uniform IViewRotMat = shader.getUniform("IViewRotMat");
        Uniform GameTime = shader.getUniform("GameTime");
        Uniform FogShape2 = shader.getUniform("FogShape");
        Uniform IntOffset = shader.getUniform("IntOffset");
        Uniform FloatOffset = shader.getUniform("FloatOffset");
        Vec3 cameraPos = event.getCamera().getPosition();
        Matrix4f spinMatrix4f = new Matrix4f();
        float shaderTime = (float)event.getRenderTick() + event.getPartialTick().getGameTimeDeltaPartialTick(false);
        spinMatrix4f.rotate(shaderTime * -0.01f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        SpinMatrix.set(new Matrix3f((Matrix4fc)spinMatrix4f));
        ModelViewMat.set(event.getModelViewMatrix());
        IViewRotMat.set(event.getPoseStack().last().normal());
        ProjMat.set(event.getProjectionMatrix());
        GameTime.set(shaderTime);
        FogShape2.set(RenderSystem.getShaderFogShape().getIndex());
        IntOffset.set((int)cameraPos.x, (int)cameraPos.y, (int)cameraPos.z);
        FloatOffset.set((float)(cameraPos.x - (double)((int)cameraPos.x)), (float)(cameraPos.y - (double)((int)cameraPos.y)), (float)(cameraPos.z - (double)((int)cameraPos.z)));
        RenderType renderType = CoreRenderTypes.icosphere((ResourceLocation)XyMachines.resource("textures/block/xynergy_core.png"));
        renderType.setupRenderState();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)XyMachines.resource("textures/block/xynergy_core.png"));
        shader.apply();
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            shader.setSampler("Sampler" + i, (Object)j);
        }
        if (shader.FOG_START != null) {
            shader.FOG_START.set(RenderSystem.getShaderFogStart());
        }
        if (shader.FOG_END != null) {
            shader.FOG_END.set(RenderSystem.getShaderFogEnd());
        }
        if (shader.FOG_COLOR != null) {
            shader.FOG_COLOR.set(RenderSystem.getShaderFogColor());
        }
        if (shader.FOG_SHAPE != null) {
            shader.FOG_SHAPE.set(RenderSystem.getShaderFogShape().getIndex());
        }
        for (DrawBatch batch : drawBatches.values()) {
            batch.rebuildInstanceData();
            batch.draw();
        }
        GL33C.glBindVertexArray((int)0);
        GL33C.glBindBuffer((int)34962, (int)0);
        renderType.clearRenderState();
        shader.clear();
    }

    static {
        VertCount = 4096;
        drawBatches = new Object2ObjectOpenHashMap();
    }

    private static class VertexDataBuilder
    implements VertexConsumer,
    MultiBufferSource {
        final ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)131072);
        int vertIndex = -1;

        private VertexDataBuilder() {
        }

        @NotNull
        public VertexConsumer getBuffer(@NotNull RenderType p_109903_) {
            return this;
        }

        @NotNull
        public VertexConsumer overlayCoords(int p_85971_, int p_85972_) {
            return this;
        }

        @NotNull
        public VertexConsumer normal(float x, float y, float z) {
            this.byteBuffer.putFloat(this.vertIndex * 32 + 12, x);
            this.byteBuffer.putFloat(this.vertIndex * 32 + 16, y);
            this.byteBuffer.putFloat(this.vertIndex * 32 + 20, z);
            return this;
        }

        public void endVertex() {
            ++this.vertIndex;
        }

        @NotNull
        public VertexConsumer addVertex(float x, float y, float z) {
            ++this.vertIndex;
            this.byteBuffer.putFloat(this.vertIndex * 32 + 0, x);
            this.byteBuffer.putFloat(this.vertIndex * 32 + 4, y);
            this.byteBuffer.putFloat(this.vertIndex * 32 + 8, z);
            return this;
        }

        @NotNull
        public VertexConsumer setColor(int i, int i1, int i2, int i3) {
            return this;
        }

        @NotNull
        public VertexConsumer setUv(float u, float v) {
            this.byteBuffer.putFloat(this.vertIndex * 32 + 24, u);
            this.byteBuffer.putFloat(this.vertIndex * 32 + 28, v);
            return this;
        }

        @NotNull
        public VertexConsumer setUv1(int i, int i1) {
            return this;
        }

        @NotNull
        public VertexConsumer setUv2(int i, int i1) {
            return this;
        }

        @NotNull
        public VertexConsumer setNormal(float x, float y, float z) {
            this.byteBuffer.putFloat(this.vertIndex * 32 + 12, x);
            this.byteBuffer.putFloat(this.vertIndex * 32 + 16, y);
            this.byteBuffer.putFloat(this.vertIndex * 32 + 20, z);
            return this;
        }
    }

    private static class DrawBatch {
        private boolean dirty = true;
        private final int InstanceData;
        private final int VAO;
        private final ObjectArrayList<SphereData> positions = new ObjectArrayList();

        DrawBatch() {
            this.InstanceData = GL33C.glGenBuffers();
            this.VAO = GL33C.glGenVertexArrays();
            this.rebuildInstanceData();
            BufferUploader.invalidate();
            GL33C.glBindVertexArray((int)this.VAO);
            GL33C.glEnableVertexAttribArray((int)0);
            GL33C.glEnableVertexAttribArray((int)1);
            GL33C.glEnableVertexAttribArray((int)2);
            GL33C.glEnableVertexAttribArray((int)3);
            GL33C.glEnableVertexAttribArray((int)4);
            GL33C.glBindBuffer((int)34962, (int)VertexData);
            GL33C.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
            GL33C.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)32, (long)12L);
            GL33C.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)32, (long)24L);
            GL33C.glBindBuffer((int)34962, (int)this.InstanceData);
            GL33C.glVertexAttribIPointer((int)3, (int)3, (int)5124, (int)16, (long)0L);
            GL33C.glVertexAttribIPointer((int)4, (int)1, (int)5124, (int)16, (long)12L);
            GL33C.glVertexAttribDivisor((int)3, (int)1);
            GL33C.glVertexAttribDivisor((int)4, (int)1);
            RenderSystem.AutoStorageIndexBuffer indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
            indexBuffer.bind(2048);
            GL33C.glBindBuffer((int)34962, (int)0);
            GL33C.glBindVertexArray((int)0);
        }

        void cleanup() {
            GL33C.glDeleteBuffers((int)this.InstanceData);
            GL33C.glDeleteVertexArrays((int)this.VAO);
        }

        void rebuildInstanceData() {
            if (!this.dirty) {
                return;
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer intBuf = stack.mallocInt(4 * this.positions.size());
                for (int i = 0; i < this.positions.size(); ++i) {
                    SphereData positionData = (SphereData)this.positions.get(i);
                    intBuf.put(i * 4 + 0, positionData.pos.getX());
                    intBuf.put(i * 4 + 1, positionData.pos.getY());
                    intBuf.put(i * 4 + 2, positionData.pos.getZ());
                    intBuf.put(i * 4 + 3, positionData.packedColor);
                }
                BufferUploader.invalidate();
                GL33C.glBindBuffer((int)34962, (int)this.InstanceData);
                GL33C.glBufferData((int)34962, (IntBuffer)intBuf, (int)35044);
                GL33C.glBindBuffer((int)34962, (int)0);
            }
            this.dirty = false;
        }

        void add(SphereData data) {
            this.dirty = true;
            this.positions.add((Object)data);
        }

        void remove(SphereData data) {
            this.dirty = true;
            this.positions.removeIf(sphereData -> sphereData.pos.equals((Object)data.pos));
        }

        void draw() {
            GL33C.glBindVertexArray((int)this.VAO);
            int indexType = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS).type().asGLType;
            GL33C.glDrawElementsInstanced((int)4, (int)VertCount, (int)indexType, (long)0L, (int)this.positions.size());
        }
    }

    public record SphereData(BlockPos pos, int packedColor) {
    }
}

