/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNodeClient;
import tv.soaryn.xycraft.core.client.shader.CoreRenderTypes;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.ClientXynergyGraphCache;
import tv.soaryn.xycraft.machines.client.render.instanced.InstancedIcosphere;
import tv.soaryn.xycraft.machines.content.attachments.level.FlareMapLevelAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class XynergyGraphRenderer {
    private static final ResourceLocation noiseResource = XyMachines.resource("textures/shaders/laser_large.png");
    private static final ResourceLocation icosphereResource = XyMachines.resource("textures/block/xynergy_core.png");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES && event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Frustum frustum = event.getFrustum();
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Camera camera = event.getCamera();
        Vec3 cameraPos = camera.getPosition();
        ClientXynergyGraphCache graph = ClientXynergyGraphCache.of((Level)level);
        ObjectSet<Long2ObjectMap.Entry<LongArrayList>> edges = graph.getEdges();
        level.getProfiler().push("xycraft_machines:xynergy.render.laser");
        XynergyGraphRenderer.setShaderValues(event.getRenderTick(), event.getPartialTick().getGameTimeDeltaPartialTick(false));
        MultiBufferSource.BufferSource renderBuffers = Minecraft.getInstance().renderBuffers().bufferSource();
        ObjectArraySet nodeCapList = new ObjectArraySet();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        VertexConsumer buffer = renderBuffers.getBuffer(CoreRenderTypes.laser((ResourceLocation)noiseResource));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)noiseResource);
        double chunkDist = event.getLevelRenderer().getLastViewDistance();
        double bound = chunkDist * 16.0 + 36.0;
        bound *= bound;
        poseStack.translate(0.5, 0.5, 0.5);
        for (Long2ObjectMap.Entry entry : edges) {
            long nodeU = entry.getLongKey();
            BlockPos pos1 = BlockPos.of((long)nodeU);
            IXynergyNodeClient node1 = (IXynergyNodeClient)level.getCapability(CoreCapabilities.XynergyNode.BLOCK_CLIENT, pos1, null);
            if (node1 == null) continue;
            int nodeColorU = XyCraftColors.Blue.getColor();
            nodeColorU = node1.getColor();
            Vector4f targetU = ColorUtils.ARGBtoHSVA((int)nodeColorU);
            poseStack.pushPose();
            poseStack.translate((double)pos1.getX() - cameraPos.x(), (double)pos1.getY() - cameraPos.y(), (double)pos1.getZ() - cameraPos.z());
            LongArrayList endpoints = (LongArrayList)entry.getValue();
            boolean isDist1Far = cameraPos.distanceToSqr(pos1.getCenter()) >= bound;
            for (long nodeV : endpoints.toLongArray()) {
                IXynergyNodeClient node2;
                BlockPos pos2 = BlockPos.of((long)nodeV);
                if (isDist1Far && cameraPos.distanceToSqr(pos2.getCenter()) >= bound || (node2 = (IXynergyNodeClient)level.getCapability(CoreCapabilities.XynergyNode.BLOCK_CLIENT, pos2, null)) == null) continue;
                int nodeColorV = node2.getColor();
                Vector4f targetV = ColorUtils.ARGBtoHSVA((int)nodeColorV);
                poseStack.pushPose();
                Vector3f vec1 = pos1.getCenter().toVector3f();
                Vector3f vec2 = pos2.getCenter().toVector3f();
                Vector3f offsetU = node1.getRenderOffset(pos2);
                Vector3f offsetV = node2.getRenderOffset(pos1);
                vec1.add((Vector3fc)offsetU);
                vec2.add((Vector3fc)offsetV);
                if (node1.hasRenderNode(pos2)) {
                    nodeCapList.add((Object)new NodeToRender(nodeColorU, (Vec3i)pos1, node1.getRenderOffset(pos2), node1.getRenderNodeSize()));
                }
                if (node2.hasRenderNode(pos1)) {
                    nodeCapList.add((Object)new NodeToRender(nodeColorV, (Vec3i)pos2, node2.getRenderOffset(pos1), node2.getRenderNodeSize()));
                }
                poseStack.translate(offsetU.x(), offsetU.y(), offsetU.z());
                XynergyGraphRenderer.renderLaserAt(cameraPos, poseStack, buffer, nodeU, nodeV, targetU, targetV, offsetU, offsetV, (Vec3i)pos1, (Vec3i)pos2);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
        renderBuffers.endBatch();
        VertexConsumer nodeBuffer = renderBuffers.getBuffer(CoreRenderTypes.laserNode((ResourceLocation)noiseResource));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)noiseResource);
        for (NodeToRender node : nodeCapList) {
            XynergyGraphRenderer.renderNode(camera, cameraPos, nodeBuffer, poseStack, node.size(), node.size(), node.color(), node.offset, node.pos);
        }
        FlareMapLevelAttachment flareData = (FlareMapLevelAttachment)level.getData(MachinesAttachments.FlareColorMapData);
        for (Object2IntMap.Entry blockPosEntry : flareData.entrySet()) {
            BlockPos pos = (BlockPos)blockPosEntry.getKey();
            if (!level.isLoaded(pos) || !frustum.isVisible(flareData.getBounds(pos))) continue;
            float width = 0.8f;
            float height = 0.8f;
            XynergyGraphRenderer.renderNode(camera, cameraPos, nodeBuffer, poseStack, width, height, blockPosEntry.getIntValue(), new Vector3f(0.0f, 0.0f, 0.0f), (Vec3i)pos);
        }
        poseStack.popPose();
        renderBuffers.endBatch();
        level.getProfiler().pop();
        level.getProfiler().push("xycraft_machines:xynergy.render.icosphere");
        InstancedIcosphere.draw(event);
        level.getProfiler().pop();
    }

    private static void renderNode(Camera camera, Vec3 cameraPos, VertexConsumer buffer, PoseStack poseStack, float width, float height, int nodeColor, Vector3f node, Vec3i pos) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - cameraPos.x(), (double)pos.getY() - cameraPos.y(), (double)pos.getZ() - cameraPos.z());
        poseStack.translate(node.x(), node.y(), node.z());
        poseStack.mulPose(camera.rotation());
        Vector4f color = ColorUtils.convertToRGBAVec((int)nodeColor);
        color.w = Math.max((float)color.w, (float)0.8f);
        XynergyGraphRenderer.addPoint(poseStack, buffer, color, -width, -height, 0.0f, 0.0f, 0.0f);
        XynergyGraphRenderer.addPoint(poseStack, buffer, color, -width, height, 0.0f, 0.0f, 1.0f);
        XynergyGraphRenderer.addPoint(poseStack, buffer, color, width, height, 0.0f, 1.0f, 1.0f);
        XynergyGraphRenderer.addPoint(poseStack, buffer, color, width, -height, 0.0f, 1.0f, 0.0f);
        poseStack.popPose();
    }

    private static void setShaderValues(int tick, float partialTick) {
        Uniform nodeRenderTime = CoreRenderTypes.Internal.laserNodeShader.getUniform("RenderTime");
        Uniform renderTime = CoreRenderTypes.Internal.laserShader.getUniform("RenderTime");
        float t = ((float)((long)tick % 24000L) + partialTick) / 24000.0f;
        nodeRenderTime.set(t);
        renderTime.set(t);
        Uniform timeFactor = CoreRenderTypes.Internal.laserShader.getUniform("TimeFactor");
        Uniform bandPower = CoreRenderTypes.Internal.laserShader.getUniform("BandPower");
        Uniform whiskPower = CoreRenderTypes.Internal.laserShader.getUniform("WhiskPower");
        Uniform outerBandPower = CoreRenderTypes.Internal.laserShader.getUniform("OuterBandPower");
        Uniform innerBandPower = CoreRenderTypes.Internal.laserShader.getUniform("InnerBandPower");
        Uniform noiseBandPower = CoreRenderTypes.Internal.laserShader.getUniform("NoiseBandPower");
        Uniform noiseMultiplier = CoreRenderTypes.Internal.laserShader.getUniform("NoiseMultiplier");
        timeFactor.set(600.0f);
        bandPower.set(2.31f);
        whiskPower.set(0.5f);
        outerBandPower.set(3.45f);
        innerBandPower.set(7.24f);
        noiseMultiplier.set(1.43f);
        noiseBandPower.set(1.0f);
        innerBandPower.set(12.0f);
        outerBandPower.set(1.45f);
        noiseBandPower.set(10.0f);
        noiseMultiplier.set(1.5f);
        OptionInstance mode = Minecraft.getInstance().options.graphicsMode();
        if (mode.get() == GraphicsStatus.FABULOUS) {
            innerBandPower.set(12.0f);
            bandPower.set(1.0f);
        } else {
            innerBandPower.set(24.0f);
            bandPower.set(1.0f);
        }
        timeFactor.set(1500.0f);
        Uniform time1 = CoreRenderTypes.Internal.laserShader.getUniform("Time1");
        Uniform time2 = CoreRenderTypes.Internal.laserShader.getUniform("Time2");
        Uniform outerNoiseStep = CoreRenderTypes.Internal.laserShader.getUniform("OuterNoiseStep");
        Uniform outerBandStep = CoreRenderTypes.Internal.laserShader.getUniform("OuterBandStep");
        Uniform innerBandStep = CoreRenderTypes.Internal.laserShader.getUniform("InnerBandStep");
        Uniform noiseCompositeStep = CoreRenderTypes.Internal.laserShader.getUniform("NoiseCompositeStep");
        Uniform whiskRemap = CoreRenderTypes.Internal.laserShader.getUniform("WhiskRemap");
        Uniform limiterStep = CoreRenderTypes.Internal.laserShader.getUniform("LimiterStep");
        Uniform upperNoiseStep = CoreRenderTypes.Internal.laserShader.getUniform("UpperNoiseStep");
        Uniform lowerNoiseStep = CoreRenderTypes.Internal.laserShader.getUniform("LowerNoiseStep");
        Uniform correctionStep = CoreRenderTypes.Internal.laserShader.getUniform("CorrectionStep");
        time1.set(0.03f, 0.05f);
        time2.set(-0.06f, -0.1f);
        outerNoiseStep.set(0.17f, 0.0f);
        outerBandStep.set(0.12f, 0.03f);
        innerBandStep.set(0.05f, 0.0f);
        noiseCompositeStep.set(-0.09f, 1.75f);
        whiskRemap.set(0.21f, 0.68f);
        limiterStep.set(0.5f, 0.79f);
        upperNoiseStep.set(0.1f, 0.9f);
        lowerNoiseStep.set(-0.22f, 0.9f);
        correctionStep.set(0.0f, 0.8f);
    }

    private static void renderLaserAt(Vec3 cameraPos, PoseStack poseStack, VertexConsumer buffer, long nodeU, long nodeV, Vector4f hsvaU, Vector4f hsvaV, Vector3f offsetU, Vector3f offsetV, Vec3i pos1, Vec3i pos2) {
        float height;
        Vector3f dirV = new Vector3f();
        Vector3f upV = new Vector3f();
        Vec3i dif = pos1.subtract(pos2);
        dirV = new Vector3f((float)dif.getX(), (float)dif.getY(), (float)dif.getZ());
        dirV.add((Vector3fc)offsetU);
        dirV.sub((Vector3fc)offsetV);
        Vec3i cameraInt = new Vec3i((int)cameraPos.x, (int)cameraPos.y, (int)cameraPos.z);
        Vector3f cameraFloat = new Vector3f((float)(cameraPos.x - (double)cameraInt.getX()), (float)(cameraPos.y - (double)cameraInt.getY()), (float)(cameraPos.z - (double)cameraInt.getZ()));
        Vec3i cameraIntDif = pos1.subtract(cameraInt);
        upV = new Vector3f((float)cameraIntDif.getX(), (float)cameraIntDif.getY(), (float)cameraIntDif.getZ());
        upV.add((Vector3fc)offsetU);
        upV.add(0.5f, 0.5f, 0.5f);
        upV.sub((Vector3fc)cameraFloat);
        upV.cross((Vector3fc)dirV);
        poseStack.pushPose();
        float magnitude = dirV.length();
        poseStack.mulPose(new Quaternionf().lookAlong((Vector3fc)dirV, (Vector3fc)upV).conjugate());
        float noiseOffset = ((float)nodeV + (float)nodeU / 2.0f) % 20.0f / 20.0f;
        Vector4f packedU = new Vector4f((Vector4fc)hsvaU);
        Vector4f packedV = new Vector4f((Vector4fc)hsvaV);
        float hueDelta = hsvaU.x - hsvaV.x;
        if ((double)Math.abs((float)hueDelta) > 0.5) {
            if (hueDelta < 0.0f) {
                packedU.x += 1.0f;
            } else {
                packedV.x += 1.0f;
            }
        }
        packedU.x /= 2.0f;
        packedV.x /= 2.0f;
        float height1 = height = 1.0f;
        float height2 = height;
        poseStack.pushPose();
        XynergyGraphRenderer.addPoint(poseStack, buffer, packedU, 0.0f, -height1, 0.0f, noiseOffset, 0.0f);
        XynergyGraphRenderer.addPoint(poseStack, buffer, packedU, 0.0f, height1, 0.0f, noiseOffset, 1.0f);
        XynergyGraphRenderer.addPoint(poseStack, buffer, packedV, 0.0f, height2, magnitude, magnitude / 2.0f + noiseOffset, 1.0f);
        XynergyGraphRenderer.addPoint(poseStack, buffer, packedV, 0.0f, -height2, magnitude, magnitude / 2.0f + noiseOffset, 0.0f);
        poseStack.popPose();
        poseStack.popPose();
    }

    private static void addPoint(PoseStack poseStack, VertexConsumer buffer, Vector4f color, float x, float y, float z, float u, float v) {
        PoseStack.Pose lastPose = poseStack.last();
        buffer.addVertex(lastPose.pose(), x, y, z).setColor(color.x(), color.y(), color.z(), color.w()).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(2000, 100).setNormal(lastPose, 0.0f, 0.0f, 0.0f);
    }

    private record NodeToRender(int color, Vec3i pos, Vector3f offset, float size) {
        NodeToRender {
            size = Math.max((float)0.55f, (float)size);
        }
    }
}

