/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.render.MachinesModelBakery;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class HoverPackArmorRenderLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation _armorLocation = XyMachines.resource("textures/armor/hover_pack.png");
    private static final ResourceLocation _emissiveLocation = XyMachines.resource("textures/armor/hover_pack.png");

    public HoverPackArmorRenderLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, @NotNull LivingEntity entity, float yaw, float pitch, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        if (entity.getItemBySlot(EquipmentSlot.CHEST).getItem() != MachinesContent.Item.HoverPack.item()) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        int color = XyCraftColors.Red.getColor();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            color = ColorUtils.multiply((int)FavoredColor.of((IAttachmentHolder)player), (float)1.0f);
        }
        poseStack.pushPose();
        model.body.translateAndRotate(poseStack);
        poseStack.mulPose(new Quaternionf().setAngleAxis(Math.PI, 0.0, 0.0, 1.0));
        MachinesModelBakery.HoverPack.render(poseStack, bufferSource, RenderType.entityCutout((ResourceLocation)XyMachines.resource("textures/item/armor/hover_pack.png")), light, -1);
        poseStack.popPose();
    }

    public static <T extends LivingEntity> void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            HoverPackArmorRenderLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.renderers.values()) {
            HoverPackArmorRenderLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.getModel() instanceof HumanoidModel)) {
            return;
        }
        HoverPackArmorRenderLayer layer = new HoverPackArmorRenderLayer(livingRenderer);
        livingRenderer.addLayer(layer);
    }
}

