/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jgrapht.Graph;
import tv.soaryn.xycraft.core.client.render.FluidRenderer;
import tv.soaryn.xycraft.machines.client.multiblock.ClientPipeGraphCacheAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class FluidPipeRenderer {
    private static final Reference2ObjectMap<RenderLevelStageEvent.Stage, RenderType> _renderTypeMap = (Reference2ObjectMap)Util.make((Object)new Reference2ObjectOpenHashMap(), map -> {
        for (RenderType renderType : RenderType.chunkBufferLayers()) {
            map.put((Object)RenderLevelStageEvent.Stage.fromRenderType((RenderType)renderType), (Object)renderType);
        }
    });

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        RenderType renderType = (RenderType)_renderTypeMap.get((Object)event.getStage());
        if (renderType == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        ClientPipeGraphCacheAttachment data = (ClientPipeGraphCacheAttachment)level.getData(MachinesAttachments.FluidPipeClientCache);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Tesselator renderBuffers = Tesselator.getInstance();
        Vec3 cameraPos = event.getCamera().getPosition();
        for (Map.Entry entry : data.IdToGraph.entrySet()) {
            RenderType renderLayer;
            UUID uuid = (UUID)entry.getKey();
            Graph graph = (Graph)entry.getValue();
            ClientPipeGraphCacheAttachment.ClientBuffer butter = (ClientPipeGraphCacheAttachment.ClientBuffer)data.IdToData.getOrDefault((Object)uuid, (Object)ClientPipeGraphCacheAttachment.ClientBuffer.Empty);
            if (butter.Fluid.isEmpty() || renderType != (renderLayer = ItemBlockRenderTypes.getRenderLayer((FluidState)butter.Fluid.getFluid().defaultFluidState()))) continue;
            renderType.setupRenderState();
            ShaderInstance shaderinstance = RenderSystem.getShader();
            if (shaderinstance == null) continue;
            if (shaderinstance.MODEL_VIEW_MATRIX != null) {
                shaderinstance.MODEL_VIEW_MATRIX.set(event.getModelViewMatrix());
            }
            if (shaderinstance.PROJECTION_MATRIX != null) {
                shaderinstance.PROJECTION_MATRIX.set(event.getProjectionMatrix());
            }
            if (shaderinstance.COLOR_MODULATOR != null) {
                shaderinstance.COLOR_MODULATOR.set(RenderSystem.getShaderColor());
            }
            if (shaderinstance.GLINT_ALPHA != null) {
                shaderinstance.GLINT_ALPHA.set(RenderSystem.getShaderGlintAlpha());
            }
            if (shaderinstance.FOG_START != null) {
                shaderinstance.FOG_START.set(RenderSystem.getShaderFogStart());
            }
            if (shaderinstance.FOG_END != null) {
                shaderinstance.FOG_END.set(RenderSystem.getShaderFogEnd());
            }
            if (shaderinstance.FOG_COLOR != null) {
                shaderinstance.FOG_COLOR.set(RenderSystem.getShaderFogColor());
            }
            if (shaderinstance.FOG_SHAPE != null) {
                shaderinstance.FOG_SHAPE.set(RenderSystem.getShaderFogShape().getIndex());
            }
            if (shaderinstance.TEXTURE_MATRIX != null) {
                shaderinstance.TEXTURE_MATRIX.set(RenderSystem.getTextureMatrix());
            }
            if (shaderinstance.GAME_TIME != null) {
                shaderinstance.GAME_TIME.set(RenderSystem.getShaderGameTime());
            }
            if (shaderinstance.CHUNK_OFFSET != null) {
                // empty if block
            }
            shaderinstance.apply();
            PoseStack poseStack = event.getPoseStack();
            float min = 0.325f;
            float max = 1.0f - min;
            IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)butter.Fluid.getFluid());
            BufferBuilder buffer = renderBuffers.begin(renderLayer.mode(), renderLayer.format());
            try (VertexBuffer vb = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);){
                Iterator iterator = graph.vertexSet().iterator();
                while (iterator.hasNext()) {
                    long posId = (Long)iterator.next();
                    pos.set(posId);
                    int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
                    poseStack.pushPose();
                    poseStack.translate((double)pos.getX() - cameraPos.x(), (double)pos.getY() - cameraPos.y(), (double)pos.getZ() - cameraPos.z());
                    FluidRenderer.renderFluidStream((FluidStack)butter.Fluid, (float)min, (float)min, (float)min, (float)max, (float)max, (float)max, (VertexConsumer)buffer, (PoseStack)poseStack, (int)clientFluid.getTintColor(butter.Fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)level, (BlockPos)pos), (int)light, (boolean)true);
                    poseStack.popPose();
                }
                MeshData render = buffer.build();
                if (render != null) {
                    vb.bind();
                    vb.upload(render);
                    vb.drawWithShader(event.getModelViewMatrix(), event.getProjectionMatrix(), shaderinstance);
                    VertexBuffer.unbind();
                }
            }
            if (shaderinstance.CHUNK_OFFSET == null) continue;
            shaderinstance.CHUNK_OFFSET.set(0.0f, 0.0f, 0.0f);
        }
    }
}

