/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.multiblock;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.multiblock.ClientTankCache;
import tv.soaryn.xycraft.machines.client.multiblock.ClientTankMultiBlock;
import tv.soaryn.xycraft.machines.client.render.TankMultiBlockRenderer;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankMultiBlock;
import tv.soaryn.xycraft.machines.network.SBOpenTankMenu;

public class ClientTankEventHandler {
    private static WeakReference<ClientTankMultiBlock> LAST_LOOKED_AT = new WeakReference<Object>(null);

    @Nullable
    public static ClientTankMultiBlock getLookedAt(Level level, BlockPos pos) {
        ClientTankMultiBlock lastLookedAt = (ClientTankMultiBlock)LAST_LOOKED_AT.get();
        if (lastLookedAt == null) {
            ClientTankMultiBlock multiBlock = TankMultiBlock.find(level, pos, ClientTankMultiBlock.class).orElse(null);
            LAST_LOOKED_AT = new WeakReference<ClientTankMultiBlock>(multiBlock);
            return multiBlock;
        }
        List<ClientTankMultiBlock> all = TankMultiBlock.findAll(level, pos, ClientTankMultiBlock.class).toList();
        if (all.contains(lastLookedAt)) {
            return lastLookedAt;
        }
        if (all.isEmpty()) {
            return null;
        }
        ClientTankMultiBlock multiBlock = all.getFirst();
        LAST_LOOKED_AT = new WeakReference<ClientTankMultiBlock>(multiBlock);
        return multiBlock;
    }

    public static Iterable<ClientTankMultiBlock> getAllTanks() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return List.of();
        }
        return ClientTankCache.of((Level)level).list();
    }

    private static void onClientLevelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            return;
        }
        ClientTankCache.of(level).list().forEach(ClientTankMultiBlock::tick);
    }

    private static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (player.isSecondaryUseActive() || ModifierKey.of((Player)player)) {
            return;
        }
        ClientTankMultiBlock tank = ClientTankEventHandler.getLookedAt(event.getLevel(), event.getPos());
        if (tank != null) {
            XyMachines.Network.send((Packet.ServerBound)new SBOpenTankMenu(tank.getOrigin(), event.getPos(), event.getHand()));
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ClientTankEventHandler::onClientLevelTick);
        NeoForge.EVENT_BUS.addListener(ClientTankEventHandler::onRightClick);
        NeoForge.EVENT_BUS.addListener(TankMultiBlockRenderer::onRenderLevel);
        NeoForge.EVENT_BUS.addListener(TankMultiBlockRenderer::onDrawHighlight);
    }
}

