/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.multiblock.ClientTankMultiBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class ClientTankCache {
    public static final AttachmentType.Builder<ClientTankCache> Builder = AttachmentType.builder(ClientTankCache::new);
    private final Long2ObjectMap<ClientTankMultiBlock> tanks = new Long2ObjectOpenHashMap();

    private ClientTankCache() {
    }

    public Iterable<ClientTankMultiBlock> list() {
        return this.tanks.values();
    }

    @Nullable
    public ClientTankMultiBlock get(BlockPos pos) {
        return (ClientTankMultiBlock)this.tanks.get(pos.asLong());
    }

    public void add(BlockPos min, BlockPos max, FluidStack fluid) {
        ClientTankMultiBlock tank = new ClientTankMultiBlock(min, max, fluid, (Integer)XyMachines.ServerConfig.TankStoragePerBlock.get());
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)Utils.getClientLevel(), ClientTankMultiBlock.class);
        long id = min.asLong();
        if (this.tanks.containsKey(id)) {
            ClientTankMultiBlock removedTank = (ClientTankMultiBlock)this.tanks.remove(id);
            lookup.remove((Object)removedTank);
        }
        this.tanks.put(id, (Object)tank);
        lookup.add((Object)tank, min, max);
    }

    public void remove(BlockPos pos) {
        ClientTankMultiBlock tank = (ClientTankMultiBlock)this.tanks.remove(pos.asLong());
        if (tank != null) {
            FastVolumeLookup.of((Level)Utils.getClientLevel(), ClientTankMultiBlock.class).remove((Object)tank);
        }
    }

    @NotNull
    public static ClientTankCache of(Level level) {
        return (ClientTankCache)level.getData(MachinesAttachments.TankClientCache);
    }
}

