/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines;

import com.mojang.serialization.MapCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.items.IHandleCreativeTab;
import tv.soaryn.xycraft.core.content.registries.IRegister;
import tv.soaryn.xycraft.core.network.NetworkHandler;
import tv.soaryn.xycraft.core.network.packets.CBRainShieldBlockPacket;
import tv.soaryn.xycraft.machines.XyMachinesClient;
import tv.soaryn.xycraft.machines.config.MachinesServerConfig;
import tv.soaryn.xycraft.machines.content.blocks.basic.LightFieldBlock;
import tv.soaryn.xycraft.machines.content.blocks.collector.CollectorBlock;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.MachinesModules;
import tv.soaryn.xycraft.machines.content.recipes.ForgecraftCondition;
import tv.soaryn.xycraft.machines.content.registries.MachineLootModifiers;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttributes;
import tv.soaryn.xycraft.machines.content.registries.MachinesCommands;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesDataComponents;
import tv.soaryn.xycraft.machines.content.registries.MachinesMenus;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;
import tv.soaryn.xycraft.machines.content.systems.MachinesSounds;
import tv.soaryn.xycraft.machines.network.CBClientTankSyncPacket;
import tv.soaryn.xycraft.machines.network.CBCollectorAbsorbedPacket;
import tv.soaryn.xycraft.machines.network.CBFlareRemovalPacket;
import tv.soaryn.xycraft.machines.network.CBFlareUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBFluidPipeGraphUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBHardenBlockPacket;
import tv.soaryn.xycraft.machines.network.CBLightVolumePacket;
import tv.soaryn.xycraft.machines.network.CBPipeGraphFormPacket;
import tv.soaryn.xycraft.machines.network.CBPipeGraphRemovePacket;
import tv.soaryn.xycraft.machines.network.CBPipeGraphRemovePipePacket;
import tv.soaryn.xycraft.machines.network.CBPipeUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBPowerCoreRemovalPacket;
import tv.soaryn.xycraft.machines.network.CBPowerCoreUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBTankFluidUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBTankFormPacket;
import tv.soaryn.xycraft.machines.network.CBTankUnformPacket;
import tv.soaryn.xycraft.machines.network.CBVoidParticlePacket;
import tv.soaryn.xycraft.machines.network.CBXynergyLaserEdgePacket;
import tv.soaryn.xycraft.machines.network.SBOpenTankMenu;

@Mod(value="xycraft_machines")
public class XyMachines
extends XyCraft {
    public static final String ModId = "xycraft_machines";
    public static final NetworkHandler Network = NetworkHandler.builder((String)"xycraft_machines", (String)"1.0.0").register("tank_form", CBTankFormPacket.class, CBTankFormPacket.SerDes).register("tank_unform", CBTankUnformPacket.class, CBTankUnformPacket.SerDes).register("tank_fluid_update", CBTankFluidUpdatePacket.class, CBTankFluidUpdatePacket.SerDes).register("tank_client_sync", CBClientTankSyncPacket.class, CBClientTankSyncPacket.SerDes).register("collector_absorbed", CBCollectorAbsorbedPacket.class, CBCollectorAbsorbedPacket.SerDes).register("open_tank_menu", SBOpenTankMenu.class, SBOpenTankMenu.SerDes).register("harden_block", CBHardenBlockPacket.class, CBHardenBlockPacket.SerDes).register("rain_shield_block", CBRainShieldBlockPacket.class, CBRainShieldBlockPacket.SerDes).register("xynergy_laser_edge", CBXynergyLaserEdgePacket.class, CBXynergyLaserEdgePacket.SerDes).register("flare_update", CBFlareUpdatePacket.class, CBFlareUpdatePacket.SerDes).register("flare_remove", CBFlareRemovalPacket.class, CBFlareRemovalPacket.SerDes).register("power_core_update", CBPowerCoreUpdatePacket.class, CBPowerCoreUpdatePacket.SerDes).register("power_core_remove", CBPowerCoreRemovalPacket.class, CBPowerCoreRemovalPacket.SerDes).register("void_particle", CBVoidParticlePacket.class, CBVoidParticlePacket.SerDes).register("pipe_update", CBPipeUpdatePacket.class, CBPipeUpdatePacket.SerDes).register("light_volume", CBLightVolumePacket.class, CBLightVolumePacket.SerDes).register("pipe_formation", CBPipeGraphFormPacket.class, CBPipeGraphFormPacket.SerDes).register("pipe_removal", CBPipeGraphRemovePacket.class, CBPipeGraphRemovePacket.SerDes).register("pipe_pos_removal", CBPipeGraphRemovePipePacket.class, CBPipeGraphRemovePipePacket.SerDes).register("pipe_graph_update", CBFluidPipeGraphUpdatePacket.class, CBFluidPipeGraphUpdatePacket.SerDes).build();
    public static final MachinesServerConfig ServerConfig = new MachinesServerConfig();
    private static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_CODECS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"xycraft_machines");
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ForgecraftCondition>> FLAG_CONDITION = CONDITION_CODECS.register("forgecraft", () -> ForgecraftCondition.CODEC);

    public static ResourceLocation resource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)ModId, (String)name);
    }

    public XyMachines(IEventBus bus) {
        super(bus, new IRegister[]{ServerConfig, MachinesContent.Map, MachinesAttributes.Instance, MachinesMenus.Instance, MachinesRecipeTypes.Instance, MachinesSounds.Instance, MachineLootModifiers.Instance, MachinesAttachments.Instance, MachinesModules.Instance, MachinesSystems.Instance, MachinesDataComponents.Instance});
        CONDITION_CODECS.register(bus);
        bus.addListener(arg_0 -> ((NetworkHandler)Network).setup(arg_0));
        bus.addListener(this::commonSetup);
        bus.addListener(this::addToCreativeTabs);
        bus.addListener(XyMachines::onEntityAttributeModification);
        NeoForge.EVENT_BUS.addListener(MachinesCommands::registerCommands);
        if (FMLEnvironment.dist.isClient()) {
            bus.addListener(XyMachinesClient::init);
        }
        NeoForgeMod.enableMilkFluid();
    }

    public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, MachinesAttributes.HoverFlight);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LightFieldBlock.init();
        CollectorBlock.init();
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, currentState) -> level.getBlockState(relativePos).is(MachinesContent.Block.WaterBlock.block()), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState()));
    }

    private void addToCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        IContent[] itemsInTab;
        for (IContent content2 : itemsInTab = (IContent[])MachinesContent.Map.MappedContent.stream().filter(content -> content.tab() != null && content.tab().isBound() && content.tab().get() == event.getTab()).toArray(IContent[]::new)) {
            if (!content2.hasPrerequisites() || !(content2 instanceof ItemLike)) continue;
            ItemLike itemLike = (ItemLike)content2;
            event.accept(itemLike);
        }
        MachinesContent.Map.MappedContent.stream().filter(iContent -> iContent instanceof ItemContent).map(ItemContent.class::cast).map(ItemContent::item).filter(IHandleCreativeTab.class::isInstance).map(IHandleCreativeTab.class::cast).forEach(iHandleCreativeTab -> iHandleCreativeTab.handle(event));
    }
}

