#version 330

//from #moj_import <fog.glsl>
float fog_distance(mat4 modelViewMat, vec3 pos, int shape) {
    if (shape == 0) {
        return length((modelViewMat * vec4(pos, 1.0)).xyz);
    } else {
        float distXZ = length((modelViewMat * vec4(pos.x, 0.0, pos.z, 1.0)).xyz);
        float distY = length((modelViewMat * vec4(0.0, pos.y, 0.0, 1.0)).xyz);
        return max(distXZ, distY);
    }
}

layout(location = 0) in vec3 Position;
layout(location = 1) in vec3 Normal;
layout(location = 2) in vec2 UV0;

layout(location = 3) in ivec3 WorldPosition;
layout(location = 4) in uint Color;

uniform mat3 SpinMatrix;
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform float GameTime;
uniform int FogShape;
uniform ivec3 IntOffset;
uniform vec3 FloatOffset;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;
out vec3 normal;
out vec3 worldViewDir;


float randomRange(vec2 seed, float min, float max) {
    float randomno = fract(sin(dot(seed, vec2(12.9898, 78.233))) * 43758.5453);
    return mix(min, max, randomno);
}

vec4 unpackColorARGB(uint color) {
    uint a = (color >> 24) & 0xFFu;
    uint r = (color >> 16) & 0xFFu;
    uint g = (color >> 8) & 0xFFu;
    uint b = (color >> 0) & 0xFFu;
    return vec4(r, g, b, a) / 255;
}

void main() {
    float angle = GameTime * 2000;

    vec3 ChunkOffset = vec3(WorldPosition - IntOffset) - FloatOffset;

    vec3 rotatedPosition = (SpinMatrix * (Position - 0.5)) + 0.5;
    vec3 pos = IViewRotMat * (rotatedPosition + ChunkOffset);
    vec3 norm = IViewRotMat * (SpinMatrix * Normal);

    float speed = 0.10;
    float rand = randomRange(normalize(Normal.xy), 0.0, 4.5);
    float breathe = (sin(GameTime * speed + rand ) + 1.0) / 2.0;

    vec3 transformedPos = pos + norm.xyz * breathe * 0.05;

    gl_Position = ProjMat * ModelViewMat * vec4(inverse(IViewRotMat) * transformedPos, 1.0);

    vertexDistance = fog_distance(ModelViewMat, pos, FogShape);
    vertexColor = unpackColorARGB(Color);
    texCoord0 = UV0;
    normal = -norm.xyz;
    worldViewDir = transformedPos;
}