/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.common.extensions.IFriendlyByteBufExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ResourceStack;
import tv.soaryn.xycraft.core.utils.serialization.BinaryReader;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.BinaryWriter;
import tv.soaryn.xycraft.core.utils.serialization.MapReader;
import tv.soaryn.xycraft.core.utils.serialization.MapSerializer;
import tv.soaryn.xycraft.core.utils.serialization.MapWriter;

public interface Serializer<T>
extends MapSerializer<T>,
BinarySerializer<T> {
    public static final Serializer<Boolean> BOOLEAN = Serializer.ofUnchecked((val, emit) -> emit.makeBoolean((boolean)val), (prev, node) -> node.asBoolean(), FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean);
    public static final Serializer<Byte> BYTE = Serializer.ofUnchecked((val, emit) -> emit.makeByte((byte)val), (prev, node) -> node.asByte(), IFriendlyByteBufExtension::writeByte, FriendlyByteBuf::readByte);
    public static final Serializer<byte[]> BYTE_ARRAY = Serializer.ofUnchecked((val, emit) -> emit.makeBlob(ByteBuffer.wrap(val)), (prev, node) -> node.asByteBlob().array(), (buf, val) -> buf.writeByteArray(val), buf -> buf.readByteArray());
    public static final Serializer<Integer> INTEGER = Serializer.ofUnchecked((val, emit) -> emit.makeInt((int)val), (prev, node) -> node.asInt(), FriendlyByteBuf::writeInt, FriendlyByteBuf::readInt);
    public static final Serializer<int[]> INTEGER_ARRAY = Serializer.ofUnchecked((val, emit) -> emit.makeBlob(IntBuffer.wrap(val)), (prev, node) -> node.asIntBlob().array(), FriendlyByteBuf::writeVarIntArray, FriendlyByteBuf::readVarIntArray);
    public static final Serializer<Long> LONG = Serializer.ofUnchecked((val, emit) -> emit.makeLong((long)val), (prev, node) -> node.asLong(), FriendlyByteBuf::writeLong, FriendlyByteBuf::readLong);
    public static final Serializer<long[]> LONG_ARRAY = Serializer.ofUnchecked((val, emit) -> emit.makeBlob(LongBuffer.wrap(val)), (prev, node) -> node.asLongBlob().array(), FriendlyByteBuf::writeLongArray, FriendlyByteBuf::readLongArray);
    public static final Serializer<String> STRING = Serializer.ofUnchecked((val, emit) -> emit.makeString((String)val), (prev, node) -> node.asString(), FriendlyByteBuf::writeUtf, FriendlyByteBuf::readUtf);
    public static final BinarySerializer<Vector3f> VECTOR3F = BinarySerializer.of((RegistryFriendlyByteBuf buf, T val) -> buf.writeFloat(val.x()).writeFloat(val.y()).writeFloat(val.z()), (RegistryFriendlyByteBuf buf) -> new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()));
    public static final BinarySerializer<Vec3i> VEC3I = BinarySerializer.of((RegistryFriendlyByteBuf buf, T val) -> buf.writeLong(new BlockPos(val).asLong()), (RegistryFriendlyByteBuf buf) -> BlockPos.of((long)buf.readLong()));
    public static final BinarySerializer<BlockPos> BLOCK_POS = BinarySerializer.of((RegistryFriendlyByteBuf buf, T val) -> buf.writeLong(val.asLong()), (RegistryFriendlyByteBuf buf) -> BlockPos.of((long)buf.readLong()));
    public static final BinarySerializer<BlockState> BLOCK_STATE = BinarySerializer.of((RegistryFriendlyByteBuf buf, T val) -> buf.writeVarInt(Block.getId((BlockState)val)), (RegistryFriendlyByteBuf buf) -> Block.stateById((int)buf.readVarInt()));
    public static final BinarySerializer<Ingredient> INGREDIENT = BinarySerializer.of(Ingredient.CONTENTS_STREAM_CODEC);
    public static final BinarySerializer<FluidIngredient> FLUID_INGREDIENT = BinarySerializer.of(FluidIngredient.STREAM_CODEC);
    public static final BinarySerializer<SizedFluidIngredient> SIZED_FLUID_INGREDIENT = BinarySerializer.of(SizedFluidIngredient.STREAM_CODEC);
    public static final BinarySerializer<SizedIngredient> SIZED_INGREDIENT = BinarySerializer.of(SizedIngredient.STREAM_CODEC);
    public static final BinarySerializer<UUID> UUID = BinarySerializer.of((arg_0, arg_1) -> ((StreamCodec)UUIDUtil.STREAM_CODEC).encode(arg_0, arg_1), arg_0 -> ((StreamCodec)UUIDUtil.STREAM_CODEC).decode(arg_0));
    public static final BinarySerializer<FluidType> FLUID_TYPE = BinarySerializer.of((RegistryFriendlyByteBuf buf, T value) -> ByteBufCodecs.registry((ResourceKey)NeoForgeRegistries.FLUID_TYPES.key()).encode((Object)buf, value), (RegistryFriendlyByteBuf buf) -> (FluidType)ByteBufCodecs.registry((ResourceKey)NeoForgeRegistries.FLUID_TYPES.key()).decode((Object)buf));
    public static final BinarySerializer<ItemStack> ITEM_STACK = BinarySerializer.of(ItemStack.OPTIONAL_STREAM_CODEC);
    public static final BinarySerializer<FluidStack> FLUID_STACK = BinarySerializer.of(FluidStack.OPTIONAL_STREAM_CODEC);
    public static final BinarySerializer<ItemResource> ITEM_RESOURCE = BinarySerializer.of(ItemResource.OPTIONAL_STREAM_CODEC);
    public static final BinarySerializer<FluidResource> FLUID_RESOURCE = BinarySerializer.of(FluidResource.OPTIONAL_STREAM_CODEC);
    public static final BinarySerializer<ResourceStack<ItemResource>> ITEM_RESOURCE_STACK = BinarySerializer.of(ResourceStack.streamCodec(ItemResource.OPTIONAL_STREAM_CODEC));
    public static final BinarySerializer<ResourceStack<FluidResource>> FLUID_RESOURCE_STACK = BinarySerializer.of(ResourceStack.streamCodec(FluidResource.OPTIONAL_STREAM_CODEC));

    @Override
    default public <V> Serializer<V> map(Function<V, T> encoder, Function<T, V> decoder) {
        return Serializer.of(MapSerializer.super.map(encoder, decoder), BinarySerializer.super.map(encoder, decoder));
    }

    @Override
    default public Serializer<T> nullable() {
        return Serializer.of(MapSerializer.super.nullable(), BinarySerializer.super.nullable());
    }

    public static <T> Serializer<T> placeholder() {
        return Serializer.of(MapSerializer.placeholder(), BinarySerializer.placeholder());
    }

    public static <T, S1, S2> Serializer<T> ofUnchecked(MapWriter.Unchecked<T, S1> mapSerializer, MapReader.Unchecked<T, S2> mapDeserializer, BinaryWriter<T> binaryWriter, BinaryReader<T> binaryReader) {
        return Serializer.of(MapSerializer.ofUnchecked(mapSerializer, mapDeserializer), BinarySerializer.of(binaryWriter, binaryReader));
    }

    public static <T> Serializer<T> of(MapWriter<T> mapWriter, MapReader<T> mapReader, BinaryWriter<T> binaryWriter, BinaryReader<T> binaryReader) {
        return Serializer.of(MapSerializer.of(mapWriter, mapReader), BinarySerializer.of(binaryWriter, binaryReader));
    }

    public static <T, V> Serializer<T> of(final MapSerializer<T> mapSerializer, final BinarySerializer<T> binarySerializer) {
        return new Serializer<T>(){

            @Override
            public <S> S serialize(T value, MapWriter.NodeEmitter<S> emit) {
                return mapSerializer.serialize(value, emit);
            }

            @Override
            public <S> T deserialize(@Nullable T value, MapReader.NodeToken<S> node) {
                return mapSerializer.deserialize(value, node);
            }

            @Override
            public void serialize(RegistryFriendlyByteBuf buf, T value) {
                binarySerializer.serialize(buf, value);
            }

            @Override
            public T deserialize(RegistryFriendlyByteBuf buf) {
                return binarySerializer.deserialize(buf);
            }

            @Override
            public Serializer<T> nullable() {
                return Serializer.of(mapSerializer.nullable(), binarySerializer.nullable());
            }
        };
    }
}

