/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.serialization.MapReader;
import tv.soaryn.xycraft.core.utils.serialization.MapWriter;
import tv.soaryn.xycraft.core.utils.serialization.functional.LambdaUtils;
import tv.soaryn.xycraft.core.utils.serialization.functional.SerializableFunction;
import tv.soaryn.xycraft.core.utils.value.Reference;
import tv.soaryn.xycraft.core.utils.value.Value;

public interface MapSerializer<T>
extends MapWriter<T>,
MapReader<T> {
    default public <V> MapSerializer<V> map(Function<V, T> encoder, Function<T, V> decoder) {
        return MapSerializer.ofUnchecked((val, emit) -> this.serialize(encoder.apply(val), emit), (prev, node) -> decoder.apply(this.deserialize(encoder.apply(prev), node)));
    }

    default public MapSerializer<@Nullable T> nullable() {
        return MapSerializer.ofUnchecked((val, node) -> val != null ? this.serialize(val, node) : node.makeEmpty(), (prev, node) -> node.exists() ? this.deserialize(prev, node) : prev);
    }

    public static <T> MapSerializer<T> placeholder() {
        return MapSerializer.ofUnchecked((val, node) -> {
            throw new NotImplementedException();
        }, (prev, node) -> {
            throw new NotImplementedException();
        });
    }

    public static <T> MapSerializer<T> singleton(T value) {
        return MapSerializer.singleton(() -> value);
    }

    public static <T> MapSerializer<T> singleton(Supplier<T> value) {
        return MapSerializer.ofUnchecked((val, node) -> node.makeEmpty(), (prev, node) -> value.get());
    }

    public static <T, S1, S2> MapSerializer<T> ofUnchecked(final MapWriter.Unchecked<T, S1> serializer, final MapReader.Unchecked<T, S2> deserializer) {
        return new MapSerializer<T>(){

            @Override
            public <S> S serialize(T value, MapWriter.NodeEmitter<S> node) {
                return serializer.serialize(value, node);
            }

            @Override
            public <S> T deserialize(@Nullable T value, MapReader.NodeToken<S> node) {
                return deserializer.deserialize(value, node);
            }
        };
    }

    public static <T> MapSerializer<T> of(final MapWriter<T> serializer, final MapReader<T> deserializer) {
        return new MapSerializer<T>(){

            @Override
            public <S> S serialize(T value, MapWriter.NodeEmitter<S> emit) {
                return serializer.serialize(value, emit);
            }

            @Override
            public <S> T deserialize(@Nullable T value, MapReader.NodeToken<S> node) {
                return deserializer.deserialize(value, node);
            }
        };
    }

    public static <T extends Enum<T>> MapSerializer<T> ofEnum(Function<String, T> deserializer) {
        return MapSerializer.ofUnchecked((val, emit) -> emit.makeString(((StringRepresentable)val).getSerializedName()), (prev, node) -> (Enum)deserializer.apply(node.asString()));
    }

    public static <T extends Enum<T>> MapSerializer<T> ofEnum(Class<T> clazz) {
        Map lookup = Arrays.stream((Enum[])clazz.getEnumConstants()).collect(Collectors.toMap(rec$ -> ((StringRepresentable)rec$).getSerializedName(), Function.identity()));
        return MapSerializer.ofEnum(lookup::get);
    }

    public static <T> MapSerializer<? extends Reference<T>> ofReference(MapSerializer<T> serializer) {
        return MapSerializer.ofUnchecked((val, emit) -> serializer.serialize(val.get(), emit), (prev, node) -> {
            if (prev != null) {
                prev.set(serializer.deserialize(prev.get(), node));
                return prev;
            }
            return new Value<Object>(serializer.deserialize(null, node));
        });
    }

    public static <T> MapSerializer<T> ofType(Supplier<T> constructor) {
        return MapSerializer.ofUnchecked((val, emit) -> emit.makeEmpty(), (prev, node) -> constructor.get());
    }

    public static <T, T1> MapSerializer<T> ofType(Function<T1, T> constructor, String name1, Function<T, T1> getter1, MapSerializer<T1> serializer) {
        return MapSerializer.ofUnchecked((val, emit) -> emit.buildMap().put(name1, serializer.serialize(getter1.apply(val), emit)).make(), (prev, node) -> {
            MapReader.NodeToken.MapToken map = node.asMap();
            return constructor.apply(serializer.deserialize(getter1.apply(prev), map.get(name1)));
        });
    }

    public static <T, T1> MapSerializer<T> ofType(Function<T1, T> constructor, SerializableFunction<T, T1> getter1, MapSerializer<T1> serializer1) {
        return MapSerializer.ofType(constructor, LambdaUtils.serialize(getter1).getImplMethodName(), getter1, serializer1);
    }

    public static <T, T1, T2> MapSerializer<T> ofType(BiFunction<T1, T2, T> constructor, String name1, Function<T, T1> getter1, MapSerializer<T1> serializer1, String name2, Function<T, T2> getter2, MapSerializer<T2> serializer2) {
        return MapSerializer.ofUnchecked((val, emit) -> emit.buildMap().put(name1, serializer1.serialize(getter1.apply(val), emit)).put(name2, serializer2.serialize(getter2.apply(val), emit)).make(), (prev, node) -> {
            MapReader.NodeToken.MapToken map = node.asMap();
            return constructor.apply(serializer1.deserialize(getter1.apply(prev), map.get(name1)), serializer2.deserialize(getter2.apply(prev), map.get(name2)));
        });
    }

    public static <T, T1, T2> MapSerializer<T> ofType(BiFunction<T1, T2, T> constructor, SerializableFunction<T, T1> getter1, MapSerializer<T1> serializer1, SerializableFunction<T, T2> getter2, MapSerializer<T2> serializer2) {
        return MapSerializer.ofType(constructor, LambdaUtils.serialize(getter1).getImplMethodName(), getter1, serializer1, LambdaUtils.serialize(getter2).getImplMethodName(), getter2, serializer2);
    }
}

