/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.slots;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.ui.slots.ColoredSlot;
import tv.soaryn.xycraft.core.ui.slots.LockableSlot;

public class FancySlot
extends Slot
implements LockableSlot,
ColoredSlot {
    private int stackLimit = 64;
    private static final Container EMPTY_CONTAINER = new SimpleContainer(0);
    private final ItemContainer inventory;
    private final int slot;
    private final Set<Consumer<FancySlot>> updateCallbacks = new HashSet<Consumer<FancySlot>>();
    private boolean locked = false;
    private int color = 0;

    public FancySlot(int x, int y, ItemContainer inventory, int slot) {
        super(inventory.asVanillaContainer(), slot, x, y);
        this.inventory = inventory;
        this.stackLimit = inventory.getSlotCapacity(slot);
        this.slot = slot;
    }

    public FancySlot lock() {
        this.locked = true;
        return this;
    }

    public FancySlot withColor(int color) {
        this.color = color;
        return this;
    }

    public FancySlot withStackSizeLimit(int limit) {
        this.stackLimit = limit;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public void onChanged(Consumer<FancySlot> callback) {
        this.updateCallbacks.add(callback);
    }

    public int getIndex() {
        return this.slot;
    }

    @NotNull
    public ItemStack getItem() {
        return this.inventory.get(this.slot);
    }

    public void set(@NotNull ItemStack stack) {
        this.inventory.set(this.slot, stack);
        for (Consumer<FancySlot> consumer : this.updateCallbacks) {
            consumer.accept(this);
        }
    }

    public void setChanged() {
        super.setChanged();
        for (Consumer<FancySlot> consumer : this.updateCallbacks) {
            consumer.accept(this);
        }
    }

    @NotNull
    public ItemStack remove(int amount) {
        ItemStack item = this.getItem();
        ItemStack split = item.split(amount);
        this.set(item);
        return split;
    }

    public int getMaxStackSize() {
        return this.stackLimit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameInventory(@NotNull Slot other) {
        if (!(other instanceof FancySlot)) return false;
        FancySlot s = (FancySlot)other;
        if (s.inventory != this.inventory) return false;
        return true;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (this.isLocked()) {
            return false;
        }
        return super.mayPlace(stack) && this.inventory.isValid(this.slot, stack);
    }

    public boolean mayPickup(@NotNull Player player) {
        if (this.isLocked()) {
            return false;
        }
        return super.mayPickup(player);
    }
}

