/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.systems;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;

public class OreGenTestSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    private final Long2IntMap yLevel = new Long2IntOpenHashMap();

    @Override
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return false;
    }

    @Override
    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
    }

    @Override
    protected void tickSystem(ServerLevel level, BlockTickSystemLevelAttachment tickData, long currentStep) {
        if (currentStep % tickData.frequency() == 0L) {
            LongArraySet toRemove = new LongArraySet();
            for (Long2IntMap.Entry entry : this.yLevel.long2IntEntrySet()) {
                int y = entry.getIntValue();
                if (y == level.getMinBuildHeight() + 1) {
                    toRemove.add(entry.getLongKey());
                    continue;
                }
                entry.setValue(y - 1);
                ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
                BlockPos.betweenClosedStream((int)chunkPos.getMinBlockX(), (int)y, (int)chunkPos.getMinBlockZ(), (int)chunkPos.getMaxBlockX(), (int)y, (int)chunkPos.getMaxBlockZ()).filter(pos -> {
                    BlockState state = level.getBlockState(pos);
                    return !state.isAir() && !state.is(Tags.Blocks.ORES);
                }).forEach(pos -> {
                    BlockState state = level.getBlockState(pos);
                    XyCraft.Logger.debug("Handling: " + String.valueOf(pos) + " : " + String.valueOf(state.getBlock()));
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                });
            }
            for (long aLong : toRemove.toLongArray()) {
                this.yLevel.remove(aLong);
            }
        }
    }

    @Override
    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        long chunkId = ChunkPos.asLong((BlockPos)pos);
        if (this.yLevel.containsKey(chunkId)) {
            return;
        }
        this.yLevel.put(chunkId, level.getMaxBuildHeight() - 1);
    }

    @Override
    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return CoreAttachments.OreGenTestData;
    }
}

