/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.stages;

import com.mojang.serialization.Codec;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.PlayerStageAttachment;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.registries.CoreStages;
import tv.soaryn.xycraft.core.content.stages.IStageType;
import tv.soaryn.xycraft.core.network.packets.CBStageSyncPacket;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;

public interface IXyStage
extends IStage {
    public static final Codec<IStage> CODEC = CoreStages.MapRegistry.byNameCodec().dispatch("predicate_type", IStage::getType, IStageType::codec);
    public static final BinarySerializer<IStage> SerDes = BinarySerializer.of((buf, value) -> buf.writeJsonWithCodec(CODEC, value), buf -> (IStage)buf.readJsonWithCodec(CODEC));

    @Override
    default public void markCompleted(Player player, boolean isComplete) {
        PlayerStageAttachment data = (PlayerStageAttachment)player.getData(CoreAttachments.PlayerStageData);
        data.stages().put((Object)this, isComplete);
        XyCore.Network.send(player, new CBStageSyncPacket(this, isComplete));
    }

    @Override
    default public boolean test(Player player) {
        PlayerStageAttachment data = (PlayerStageAttachment)player.getData(CoreAttachments.PlayerStageData);
        return data.stages().getOrDefault((Object)this, false);
    }

    public String getLanguageKey();

    @Override
    default public Component presentedLabel() {
        return Component.translatable((String)this.getLanguageKey());
    }

    @EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME)
    public static interface EventHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerStageAttachment data = (PlayerStageAttachment)event.getEntity().getData(CoreAttachments.PlayerStageData);
            data.stages().forEach((stage, value) -> XyCore.Network.send(event.getEntity(), new CBStageSyncPacket((IStage)stage, (boolean)value)));
        }

        @SubscribeEvent
        public static void onClone(PlayerEvent.Clone event) {
            PlayerStageAttachment fromData = (PlayerStageAttachment)event.getOriginal().getData(CoreAttachments.PlayerStageData);
            fromData.stages().forEach((stage, value) -> XyCore.Network.send(event.getEntity(), new CBStageSyncPacket((IStage)stage, (boolean)value)));
        }

        @SubscribeEvent
        public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
            PlayerStageAttachment fromData = (PlayerStageAttachment)event.getEntity().getData(CoreAttachments.PlayerStageData);
            fromData.stages().forEach((stage, value) -> XyCore.Network.send(event.getEntity(), new CBStageSyncPacket((IStage)stage, (boolean)value)));
        }
    }
}

