/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.commands;

import com.google.common.base.CaseFormat;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import tv.soaryn.xycraft.core.content.commands.ICommand;
import tv.soaryn.xycraft.core.content.registries.CoreSystems;

public record SystemCommand() implements ICommand
{
    public static ICommand register(RegisterCommandsEvent event) {
        return new SystemCommand().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection(), event.getBuildContext());
    }

    @Override
    public ICommand register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandBuildContext context) {
        CoreSystems.MapRegistry.stream().forEach(system -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"xycraft").requires(ICommand::gamemaster)).then(Commands.literal((String)"systems").then(((LiteralArgumentBuilder)Commands.literal((String)system.getName()).then(((LiteralArgumentBuilder)Commands.literal((String)"enabled").executes(context1 -> {
            CommandSourceStack source = (CommandSourceStack)context1.getSource();
            if (source.hasPermission(3)) {
                Object data = system.getData((Level)source.getLevel());
                boolean isEnabled = data.enabled();
                source.sendSuccess(() -> Component.translatable((String)"xycraft.commands.system.enabled", (Object[])new Object[]{CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, system.getName()), isEnabled ? "enabled" : "disabled"}).withColor(-1431655766), true);
            }
            return 1;
        })).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).suggests((p_309113_, p_309105_) -> SharedSuggestionProvider.suggest((String[])new String[]{"false", "true"}, (SuggestionsBuilder)p_309105_)).executes(commandStack -> {
            boolean value = BoolArgumentType.getBool((CommandContext)commandStack, (String)"enabled");
            Object data = system.getData((Level)((CommandSourceStack)commandStack.getSource()).getLevel());
            data.setEnabled(value);
            ((CommandSourceStack)commandStack.getSource()).sendSuccess(() -> Component.translatable((String)"xycraft.commands.system.enabled", (Object[])new Object[]{CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, system.getName()), value ? "enabled" : "disabled"}).withColor(-1431655766), true);
            return data.enabled() ? 1 : 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"frequency").executes(context1 -> {
            Object data = system.getData((Level)((CommandSourceStack)context1.getSource()).getLevel());
            long freq = data.frequency();
            ((CommandSourceStack)context1.getSource()).sendSuccess(() -> Component.translatable((String)"xycraft.commands.system.frequency", (Object[])new Object[]{CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, system.getName()), freq}).withColor(-1431655766), true);
            return 1;
        })).then(Commands.argument((String)"frequency", (ArgumentType)TimeArgument.time((int)1)).suggests((commandStack, p_309105_) -> SharedSuggestionProvider.suggest((String[])new String[]{"1s", "5t", "%dt".formatted(system.getData((Level)((CommandSourceStack)commandStack.getSource()).getLevel()).frequency())}, (SuggestionsBuilder)p_309105_)).executes(commandStack -> {
            int value = Mth.clamp((int)IntegerArgumentType.getInteger((CommandContext)commandStack, (String)"frequency"), (int)1, (int)10000);
            Object data = system.getData((Level)((CommandSourceStack)commandStack.getSource()).getLevel());
            data.setFrequency(value);
            ((CommandSourceStack)commandStack.getSource()).sendSuccess(() -> Component.translatable((String)"xycraft.commands.system.frequency", (Object[])new Object[]{CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, system.getName()), value}).withColor(-1431655766), true);
            return (int)data.frequency();
        })))))));
        return this;
    }
}

