/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.pipes;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.pipes.EdgeData;
import tv.soaryn.xycraft.api.content.pipes.PipeGraphState;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;

public abstract class PipeGraph<TCapability, TGraph extends PipeGraph<TCapability, TGraph>> {
    private final PipeRoute<TCapability> _route;
    private final UUID _id;
    private PipeGraphState _isValid = PipeGraphState.INVALID;
    public boolean IsLoaded;

    public static <TCapability, TGraph extends PipeGraph<TCapability, TGraph>> Products.P2<RecordCodecBuilder.Mu<TGraph>, UUID, PipeRoute<TCapability>> pipeGroup(RecordCodecBuilder.Instance<TGraph> builder, BlockCapability<TCapability, Direction> pipeCap) {
        return builder.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(PipeGraph::id), (App)PipeRoute.codec(PipeRoute::new, pipeCap).fieldOf("graph").forGetter(PipeGraph::getRouteContainer));
    }

    public PipeGraph(UUID uuid, PipeRoute<TCapability> pipeRoute) {
        this._id = uuid;
        this._route = pipeRoute;
        pipeRoute._invalidator = () -> this.setValid(PipeGraphState.INVALID);
    }

    public void copyDataFrom(TGraph otherGraph) {
    }

    public abstract void rebuild(ServerLevel var1);

    public void loadCaches(ServerLevel level) {
    }

    public PipeRoute<TCapability> getRouteContainer() {
        return this._route;
    }

    public UUID id() {
        return this._id;
    }

    public PipeGraphState state() {
        return this._isValid;
    }

    public void setValid(PipeGraphState value) {
        this._isValid = value;
    }

    void preTick_internal(ServerLevel level) {
        switch (this._isValid) {
            case INVALID: {
                this._isValid = PipeGraphState.BUILDING;
                this.rebuild(level);
                break;
            }
            case BUILDING: {
                return;
            }
        }
        if (!this.getRouteContainer().Inspector.isConnected()) {
            this.setValid(PipeGraphState.INVALID);
        }
        this.preTick(level);
    }

    public abstract void preTick(ServerLevel var1);

    public abstract void postTick(ServerLevel var1);

    public void onGraphForm(ServerLevel level, UUID uuid, LongArraySet nodes, Set<EdgeData> edges) {
    }

    public void onGraphRemove(ServerLevel level, UUID uuids) {
    }

    public void onPipeRemoved(ServerLevel level, long posId) {
    }

    public boolean canMerge(@Nullable TGraph otherGraph) {
        return true;
    }
}

