/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.capabilities;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public enum PipeConnectionType implements StringRepresentable
{
    None("none"),
    Transfer("transfer"),
    Insert("insert"),
    Extract("extract");

    private final String _name;
    private static final Lazy<Reference2ReferenceMap<PipeConnectionType, PipeConnectionType>> _nextMap;
    private static final Lazy<Reference2ReferenceMap<PipeConnectionType, PipeConnectionType>> _prevMap;
    public static final StringRepresentable.StringRepresentableCodec<PipeConnectionType> CODEC;

    private PipeConnectionType(String type) {
        this._name = type;
    }

    @NotNull
    public String getSerializedName() {
        return this._name;
    }

    public PipeConnectionType composite(PipeConnectionType otherType) {
        if (this == Transfer) {
            return otherType;
        }
        if (otherType == Transfer || otherType == this) {
            return this;
        }
        return None;
    }

    public PipeConnectionType reverse() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> None;
            case 1 -> Transfer;
            case 2 -> Extract;
            case 3 -> Insert;
        };
    }

    public PipeConnectionType cycle(boolean forward) {
        return forward ? this.next() : this.prev();
    }

    public PipeConnectionType next() {
        return (PipeConnectionType)((Object)((Reference2ReferenceMap)_nextMap.get()).get((Object)this));
    }

    public PipeConnectionType prev() {
        return (PipeConnectionType)((Object)((Reference2ReferenceMap)_prevMap.get()).get((Object)this));
    }

    public boolean isIn() {
        return this == Transfer || this == Insert;
    }

    public boolean isOut() {
        return this == Transfer || this == Extract;
    }

    static {
        _nextMap = Lazy.of(() -> {
            Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
            map.put((Object)None, (Object)Transfer);
            map.put((Object)Transfer, (Object)Insert);
            map.put((Object)Insert, (Object)Extract);
            map.put((Object)Extract, (Object)None);
            return map;
        });
        _prevMap = Lazy.of(() -> {
            Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
            map.put((Object)None, (Object)Extract);
            map.put((Object)Transfer, (Object)None);
            map.put((Object)Insert, (Object)Transfer);
            map.put((Object)Extract, (Object)Insert);
            return map;
        });
        CODEC = StringRepresentable.fromEnum(PipeConnectionType::values);
    }
}

