/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.facade.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.cables.blocks.NetCableBlock;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.blocks.FacadeBlockItem;
import mcjty.xnet.modules.facade.blocks.FacadeTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class FacadeBlock
extends NetCableBlock
implements EntityBlock {
    public FacadeBlock(GenericCableBlock.CableBlockType type) {
        super(type);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FacadeTileEntity(pPos, pState);
    }

    public void playerDestroy(@Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, @Nonnull ItemStack stack) {
        ItemStack item = new ItemStack((ItemLike)FacadeModule.FACADE.get());
        BlockState mimicBlock = te instanceof FacadeTileEntity ? ((FacadeTileEntity)te).getMimicBlock() : Blocks.COBBLESTONE.defaultBlockState();
        FacadeBlockItem.setMimicBlock(item, mimicBlock);
        FacadeBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)item);
    }

    private boolean replaceWithCable(LevelAccessor world, BlockPos pos, BlockState state) {
        CableColor color = (CableColor)((Object)state.getValue((Property)COLOR));
        BlockState defaultState = (BlockState)((NetCableBlock)((Object)CableModule.NETCABLE.get())).defaultBlockState().setValue((Property)COLOR, (Comparable)((Object)color));
        BlockState newState = this.calculateState(world, pos, defaultState);
        return world.setBlock(pos, newState, world.isClientSide() ? 11 : 3);
    }

    public void destroy(LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (world.isClientSide()) {
            this.replaceWithCable(world, pos, state);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.replaceWithCable((LevelAccessor)world, pos, state);
    }

    @Override
    public void onRemove(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, world, pos, newState, isMoving);
    }
}

