/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.controller;

import java.util.ArrayList;
import java.util.function.Supplier;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.xnet.modules.controller.ChannelInfo;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.controller.client.GuiController;
import mcjty.xnet.modules.controller.data.ControllerData;
import mcjty.xnet.setup.Registration;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ControllerModule
implements IModule {
    public static final RBlock<BaseBlock, BlockItem, TileEntityController> CONTROLLER = Registration.RBLOCKS.registerBlock("controller", TileEntityController.class, TileEntityController::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), TileEntityController::new);
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_CONTROLLER = Registration.CONTAINERS.register("controller", GenericContainer::createContainerType);
    public static final Supplier<AttachmentType<ControllerData>> CONTROLLER_DATA = Registration.ATTACHMENT_TYPES.register("controller_data", () -> AttachmentType.builder(() -> {
        ControllerData data = new ControllerData(0, new ArrayList<ChannelInfo>());
        for (int i = 0; i < 8; ++i) {
            data.channels().add(ChannelInfo.EMPTY);
        }
        return data;
    }).serialize(ControllerData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ControllerData>> ITEM_CONTROLLER_DATA = Registration.COMPONENTS.registerComponentType("controller_data", builder -> builder.persistent(ControllerData.CODEC).networkSynchronized(ControllerData.STREAM_CODEC));

    public ControllerModule(IEventBus bus) {
        bus.addListener(this::registerScreens);
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
    }

    public void registerScreens(RegisterMenuScreensEvent event) {
        GuiController.register(event);
    }

    public void initConfig(IEventBus bus) {
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider provider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(CONTROLLER).ironPickaxeTags().parentedItem("block/controller").standardLoot(new DataComponentType[]{(DataComponentType)ITEM_CONTROLLER_DATA.get()}).blockState(p -> {
            ModelFile modelOk = p.frontBasedModel("controller", p.modLoc("block/machine_controller"));
            ModelFile modelError = p.frontBasedModel("controller_error", p.modLoc("block/machine_controller_error"));
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)CONTROLLER.block().get());
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelOk), direction);
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelError), direction);
            }
        }).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).define(Character.valueOf('I'), (ItemLike)Items.REPEATER).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"ICI", "rFr", "igi"})});
    }
}

