/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.tiles.IConnectorTile;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.cables.data.ConnectorData;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.MimicBlockSupport;
import mcjty.xnet.modules.facade.data.MimicData;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ConnectorTileEntity
extends GenericTileEntity
implements IFacadeSupport,
IConnectorTile {
    private int energy = 0;
    private int[] inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
    private int pulseCounter;
    private final int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private byte enabled = (byte)63;
    private final Lazy<SidedHandler>[] sidedStorages;
    private final Block[] cachedNeighbours = new Block[OrientationTools.DIRECTION_VALUES.length];
    @GuiValue
    private String name = "";
    public static final Function<ConnectorTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider(I18nConstants.BLOCK_CONNECTOR.i18n(new Object[0])).containerSupplier(DefaultContainerProvider.empty(CableModule.CONTAINER_CONNECTOR, (GenericTileEntity)be));
    public static final Key<Integer> PARAM_FACING = new Key("facing", Type.INTEGER);
    public static final Key<Boolean> PARAM_ENABLED = new Key("enabled", Type.BOOLEAN);
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ENABLE = Command.create((String)"connector.enable", (te, playerEntity, params) -> {
        int f = (Integer)params.get(PARAM_FACING);
        boolean e = (Boolean)params.get(PARAM_ENABLED);
        te.setEnabled(OrientationTools.DIRECTION_VALUES[f], e);
    });
    @ServerCommand
    public static final ResultCommand<?> CMD_GET_NAME = ResultCommand.create((String)"xnet.connector.name", (te, player, params) -> TypedMap.builder().put(PARAM_NAME, (Object)te.getConnectorName()).build(), (te, player, params) -> te.setConnectorName((String)params.get(PARAM_NAME)));

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide && this.getMimicBlock() != null) {
            this.level.setBlockAndUpdate(this.worldPosition, this.getBlockState());
        }
    }

    public ConnectorTileEntity(BlockPos pos, BlockState state) {
        this(CableModule.TYPE_CONNECTOR.get(), pos, state);
    }

    protected ConnectorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.sidedStorages = new Lazy[OrientationTools.DIRECTION_VALUES.length];
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            this.sidedStorages[direction.ordinal()] = Lazy.of(() -> this.createSidedHandler(direction));
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        if (this.level.isClientSide) {
            this.requestModelDataUpdate();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(Direction side, int powerOut) {
        if (powerOut > 15) {
            powerOut = 15;
        }
        if (this.powerOut[side.ordinal()] == powerOut) {
            return;
        }
        this.powerOut[side.ordinal()] = powerOut;
        this.setChanged();
        this.level.neighborChanged(this.worldPosition.relative(side), this.getBlockState().getBlock(), this.worldPosition);
    }

    public void setEnabled(Direction direction, boolean e) {
        this.enabled = e ? (byte)(this.enabled | 1 << direction.ordinal()) : (byte)(this.enabled & ~(1 << direction.ordinal()));
        this.setChanged();
        Block block = this.getBlockState().getBlock();
        if (block instanceof GenericCableBlock) {
            this.level.setBlock(this.worldPosition, ((GenericCableBlock)block).calculateState((LevelAccessor)this.level, this.worldPosition, this.getBlockState()), 3);
        }
    }

    public boolean isEnabled(Direction direction) {
        return (this.enabled & 1 << direction.ordinal()) != 0;
    }

    @Override
    public BlockState getMimicBlock() {
        BlockState state = ((MimicData)this.getData(FacadeModule.MIMIC_DATA)).state();
        if (state == null || state.isAir()) {
            return null;
        }
        return state;
    }

    public void setMimicBlock(BlockState mimicBlock) {
        if (mimicBlock == null) {
            mimicBlock = Blocks.AIR.defaultBlockState();
        }
        this.setData(FacadeModule.MIMIC_DATA, new MimicData(mimicBlock));
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel == 0 && powered > 0) {
            ++this.pulseCounter;
        }
        super.setPowerInput(powered);
    }

    public int getPulseCounter() {
        return this.pulseCounter;
    }

    public void possiblyMarkNetworkDirty(@Nonnull BlockPos neighbor) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!this.getBlockPos().relative(facing).equals((Object)neighbor)) continue;
            Block newblock = this.level.getBlockState(neighbor).getBlock();
            if (newblock != this.cachedNeighbours[facing.ordinal()]) {
                this.cachedNeighbours[facing.ordinal()] = newblock;
                WorldBlob worldBlob = XNetBlobData.get(this.level).getWorldBlob(this.level);
                worldBlob.markNetworkDirty(worldBlob.getNetworkAt(this.getBlockPos()));
            }
            return;
        }
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.energy = tagCompound.getInt("energy");
        this.inputFromSide = tagCompound.getIntArray("inputs");
        if (this.inputFromSide.length != 6) {
            this.inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.pulseCounter = tagCompound.getInt("pulse");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.getByte("p" + i);
        }
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putInt("energy", this.energy);
        tagCompound.putIntArray("inputs", this.inputFromSide);
        tagCompound.putInt("pulse", this.pulseCounter);
        for (int i = 0; i < 6; ++i) {
            tagCompound.putByte("p" + i, (byte)this.powerOut[i]);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        ConnectorData data = (ConnectorData)input.get(CableModule.ITEM_CONNECTOR_DATA);
        if (data != null) {
            this.setData(CableModule.CONNECTOR_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(CableModule.ITEM_CONNECTOR_DATA, (Object)((ConnectorData)this.getData(CableModule.CONNECTOR_DATA)));
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        MimicBlockSupport.writeToNBT(tagCompound, this.getMimicBlock());
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        BlockState state = MimicBlockSupport.readFromNBT(provider, tagCompound);
        if (state == null) {
            state = Blocks.AIR.defaultBlockState();
        }
        this.setData(FacadeModule.MIMIC_DATA, new MimicData(state));
    }

    public void setConnectorName(String n) {
        this.name = n;
        this.setChanged();
    }

    public String getConnectorName() {
        return this.name;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        if (this.energy != energy) {
            if (energy < 0) {
                energy = 0;
            }
            this.energy = energy;
            this.markDirtyQuick();
        }
    }

    public void setEnergyInputFrom(Direction from, int rate) {
        if (this.inputFromSide[from.ordinal()] != rate) {
            this.inputFromSide[from.ordinal()] = rate;
            this.markDirtyQuick();
        }
    }

    public int getMaxEnergy() {
        return (Integer)Config.maxRfConnector.get();
    }

    private int receiveEnergyInternal(Direction from, int maxReceive, boolean simulate) {
        if (from == null) {
            return 0;
        }
        int m = this.inputFromSide[from.ordinal()];
        if (m > 0) {
            int toreceive = Math.min(maxReceive, m);
            int newenergy = this.energy + toreceive;
            if (newenergy > this.getMaxEnergy()) {
                toreceive -= newenergy - this.getMaxEnergy();
                newenergy = this.getMaxEnergy();
            }
            if (!simulate && this.energy != newenergy) {
                this.energy = newenergy;
                this.inputFromSide[from.ordinal()] = 0;
                this.markDirtyQuick();
            }
            return toreceive;
        }
        return 0;
    }

    private int getEnergyStoredInternal() {
        return this.energy;
    }

    private int getMaxEnergyStoredInternal() {
        return this.getMaxEnergy();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(GenericCableBlock.FACADEID, (Object)this.getMimicBlock()).build();
    }

    public IEnergyStorage getEnergyStorage(Direction facing) {
        if (facing == null) {
            return null;
        }
        return (IEnergyStorage)this.sidedStorages[facing.ordinal()].get();
    }

    private SidedHandler createSidedHandler(Direction facing) {
        return new SidedHandler(facing);
    }

    class SidedHandler
    implements IEnergyStorage {
        private final Direction facing;

        public SidedHandler(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return ConnectorTileEntity.this.receiveEnergyInternal(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ConnectorTileEntity.this.getEnergyStoredInternal();
        }

        public int getMaxEnergyStored() {
            return ConnectorTileEntity.this.getMaxEnergyStoredInternal();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

