/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class ChargerRenderer
implements CustomBlockEntityRenderer<ChargerBlockEntity> {
    public void render(ChargerBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        BakedModel model = ClientUtils.getMinecraft().getModelManager().getModel(new ModelResourceLocation(entity.type.modelType.ringModel, "standalone"));
        poseStack.pushPose();
        poseStack.translate(0.5, 0.05 * Math.sin((double)(((float)entity.renderingTickCount + partialTicks) % 100.0f) / 100.0 * 2.0 * Math.PI), 0.5);
        poseStack.mulPose(new Quaternionf().setAngleAxis((entity.renderingRotation + entity.renderingRotationSpeed * partialTicks) / 3.0f, 0.0f, 1.0f, 0.0f));
        poseStack.translate(-0.5, 0.0, -0.5);
        RandomSource randomsource = RandomSource.create();
        randomsource.setSeed(42L);
        for (RenderType renderType : model.getRenderTypes(entity.getBlockState(), randomsource, ModelData.EMPTY)) {
            ClientUtils.getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(renderType), entity.getBlockState(), model, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, ModelData.EMPTY, renderType);
        }
        poseStack.translate(0.0, entity.type.modelType.ringYOffset, 0.0);
        randomsource.setSeed(42L);
        for (RenderType renderType : model.getRenderTypes(entity.getBlockState(), randomsource, ModelData.EMPTY)) {
            ClientUtils.getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(renderType), entity.getBlockState(), model, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, ModelData.EMPTY, renderType);
        }
        poseStack.popPose();
        if (entity.isAreaHighlighted()) {
            AABB area = entity.getOperatingArea().move((double)(-entity.getBlockPos().getX()), (double)(-entity.getBlockPos().getY()), (double)(-entity.getBlockPos().getZ())).inflate(0.05);
            Random random = new Random(entity.getBlockPos().hashCode());
            float red = random.nextFloat();
            float green = random.nextFloat();
            float blue = random.nextFloat();
            float alpha = 0.2f;
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)area, (float)red, (float)green, (float)blue, (boolean)true);
            RenderUtils.renderBoxSides((PoseStack)poseStack, (AABB)area, (float)red, (float)green, (float)blue, (float)alpha, (boolean)true);
        }
    }
}

