/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.compat.ModCompatibility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ChargerBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    private static final int SEARCH_BLOCKS_PER_TICK = 5;
    private static final Set<Direction> CAPABILITY_DIRECTIONS;
    public final ChargerType type;
    private int energy;
    private boolean highlightArea;
    private RedstoneMode redstoneMode = RedstoneMode.DISABLED;
    private boolean isRedstonePowered;
    private int blockSearchX;
    private int blockSearchY;
    private int blockSearchZ;
    private final Map<BlockPos, Direction> chargeableBlocks = new LinkedHashMap<BlockPos, Direction>();
    public int renderingTickCount = 0;
    public float renderingRotationSpeed;
    public float renderingRotation;

    public ChargerBlockEntity(ChargerType type, BlockPos pos, BlockState state) {
        super(type.getBlockEntityType(), pos, state);
        this.type = type;
    }

    public void update() {
        if (this.level.isClientSide) {
            ++this.renderingTickCount;
            if (!this.redstoneMode.canOperate(this.isRedstonePowered)) {
                this.renderingRotationSpeed = Math.max(0.0f, this.renderingRotationSpeed - 0.02f);
                this.renderingRotation += this.renderingRotationSpeed;
                return;
            }
            this.renderingRotationSpeed = Math.min(this.renderingRotationSpeed + 0.02f, this.getEnergyFillPercentage());
            this.renderingRotation += this.renderingRotationSpeed;
        } else {
            IEnergyStorage storage;
            boolean spawnParticles = false;
            if (this.type.canChargeBlocks) {
                for (int i = 0; i < 5; ++i) {
                    BlockPos offset = new BlockPos(this.blockSearchX, this.blockSearchY, this.blockSearchZ);
                    BlockPos blockPos = this.worldPosition.offset((Vec3i)offset);
                    if (!blockPos.equals((Object)this.worldPosition)) {
                        BlockEntity entity = this.level.getBlockEntity(blockPos);
                        boolean canAcceptEnergy = false;
                        for (Direction direction : CAPABILITY_DIRECTIONS) {
                            if (entity == null || entity instanceof ChargerBlockEntity || (storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, blockPos, null, entity, (Object)direction)) == null || !storage.canReceive()) continue;
                            this.chargeableBlocks.put(offset, direction);
                            canAcceptEnergy = true;
                            break;
                        }
                        if (!canAcceptEnergy) {
                            this.chargeableBlocks.remove(offset);
                        }
                    }
                    int range = this.type.range.get();
                    ++this.blockSearchX;
                    if (this.blockSearchX <= range) continue;
                    this.blockSearchX = -range;
                    ++this.blockSearchZ;
                    if (this.blockSearchZ <= range) continue;
                    this.blockSearchZ = -range;
                    ++this.blockSearchY;
                    if (this.blockSearchY <= range) continue;
                    this.blockSearchY = -range;
                }
                if (this.energy > 0 && this.redstoneMode.canOperate(this.isRedstonePowered)) {
                    HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
                    for (Map.Entry<Object, Object> entry : this.chargeableBlocks.entrySet()) {
                        BlockEntity entity = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)entry.getKey()));
                        if (entity != null && !(entity instanceof ChargerBlockEntity)) {
                            IEnergyStorage storage2 = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, (BlockPos)entry.getKey(), null, entity, (Object)((Direction)entry.getValue()));
                            if (storage2 != null && storage2.canReceive()) {
                                int toTransfer = Math.min(this.energy, this.type.transferRate.get());
                                int transferred = storage2.receiveEnergy(toTransfer, false);
                                if (transferred <= 0) continue;
                                spawnParticles = true;
                                this.energy -= transferred;
                                this.dataChanged();
                                if (this.energy > 0) continue;
                                break;
                            }
                            toRemove.add((BlockPos)entry.getKey());
                            continue;
                        }
                        toRemove.add((BlockPos)entry.getKey());
                    }
                    toRemove.forEach(this.chargeableBlocks::remove);
                }
            }
            if (this.type.canChargePlayers && this.energy > 0 && this.redstoneMode.canOperate(this.isRedstonePowered)) {
                List players = this.level.getEntitiesOfClass(Player.class, this.getOperatingArea());
                block3: for (Player player : players) {
                    int toTransfer = Math.min(this.energy, this.type.transferRate.get());
                    IItemHandlerModifiable handler = ModCompatibility.curios.getCuriosStacks(player);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        int max;
                        int transferred;
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.isEmpty() || (storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null || !storage.canReceive() || (transferred = storage.receiveEnergy(max = toTransfer, false)) <= 0) continue;
                        handler.setStackInSlot(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block3;
                        if ((toTransfer -= transferred) <= 0) continue block3;
                    }
                    Inventory inventory = player.getInventory();
                    for (int i = 0; i < inventory.getContainerSize(); ++i) {
                        int max;
                        int transferred;
                        IEnergyStorage storage3;
                        ItemStack stack = inventory.getItem(i);
                        if (stack.isEmpty() || (storage3 = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null || !storage3.canReceive() || (transferred = storage3.receiveEnergy(max = toTransfer, false)) <= 0) continue;
                        inventory.setItem(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block3;
                        if ((toTransfer -= transferred) <= 0) continue block3;
                    }
                }
            }
            if (spawnParticles && this.level instanceof ServerLevel && this.level.getRandom().nextDouble() <= (double)this.getEnergyFillPercentage()) {
                double x = (double)this.worldPosition.getX() + 0.5 + (double)this.level.getRandom().nextFloat() * 0.8 - 0.4;
                double d = (double)this.worldPosition.getY() + 0.7 + (double)this.level.getRandom().nextFloat() * 0.8 - 0.4;
                double z = (double)this.worldPosition.getZ() + 0.5 + (double)this.level.getRandom().nextFloat() * 0.8 - 0.4;
                ((ServerLevel)this.level).sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, x, d, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public float getEnergyFillPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.energy / (float)this.type.capacity.get().intValue()));
    }

    public AABB getOperatingArea() {
        return new AABB(this.worldPosition).inflate((double)this.type.range.get().intValue());
    }

    public void setRedstonePowered(boolean powered) {
        if (this.isRedstonePowered != powered) {
            this.isRedstonePowered = powered;
            this.dataChanged();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex((this.redstoneMode.index + 1) % RedstoneMode.values().length);
        this.dataChanged();
    }

    public boolean isAreaHighlighted() {
        return this.highlightArea;
    }

    public void toggleHighlightArea() {
        this.highlightArea = !this.highlightArea;
        this.dataChanged();
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        compound.putInt("energy", this.energy);
        compound.putBoolean("highlightArea", this.highlightArea);
        compound.putInt("redstoneMode", this.redstoneMode.index);
        compound.putBoolean("isRedstonePowered", this.isRedstonePowered);
        if (this.type.canChargeBlocks) {
            compound.putInt("blockSearchX", this.blockSearchX);
            compound.putInt("blockSearchY", this.blockSearchX);
            compound.putInt("blockSearchZ", this.blockSearchX);
            int[] arr = new int[this.chargeableBlocks.size() * 4];
            int index = 0;
            for (Map.Entry<BlockPos, Direction> entry : this.chargeableBlocks.entrySet()) {
                arr[index] = entry.getKey().getX();
                arr[index + 1] = entry.getKey().getY();
                arr[index + 2] = entry.getKey().getZ();
                arr[index + 3] = entry.getValue() == null ? -1 : entry.getValue().get3DDataValue();
                ++index;
            }
            compound.putIntArray("chargeableBlocks", arr);
        }
        return compound;
    }

    public CompoundTag writeItemStackData() {
        CompoundTag compound = this.writeData();
        if (compound.getInt("energy") <= 0 && compound.getInt("redstoneMode") == 2) {
            return null;
        }
        compound.remove("highlightArea");
        compound.remove("isRedstonePowered");
        if (this.type.canChargeBlocks) {
            compound.remove("blockSearchX");
            compound.remove("blockSearchY");
            compound.remove("blockSearchZ");
            compound.remove("chargeableBlocks");
        }
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.energy = compound.getInt("energy");
        this.highlightArea = compound.getBoolean("highlightArea");
        this.redstoneMode = RedstoneMode.fromIndex(compound.getInt("redstoneMode"));
        this.isRedstonePowered = compound.getBoolean("isRedstonePowered");
        if (this.type.canChargeBlocks && compound.contains("chargeableBlocks")) {
            this.blockSearchX = compound.getInt("blockSearchX");
            this.blockSearchY = compound.getInt("blockSearchY");
            this.blockSearchZ = compound.getInt("blockSearchZ");
            int[] arr = compound.getIntArray("chargeableBlocks");
            this.chargeableBlocks.clear();
            for (int i = 0; i < arr.length / 4; ++i) {
                this.chargeableBlocks.put(new BlockPos(arr[i], arr[i + 1], arr[i + 2]), arr[i + 3] == -1 ? null : Direction.from3DDataValue((int)arr[i + 3]));
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(maxReceive, Math.min(this.type.capacity.get() - this.energy, this.type.transferRate.get() * 100));
        if (!simulate) {
            this.energy += received;
            this.dataChanged();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.type.capacity.get();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    static {
        HashSet<Direction> directions = new HashSet<Direction>();
        directions.add(null);
        directions.addAll(Arrays.asList(Direction.values()));
        CAPABILITY_DIRECTIONS = Collections.unmodifiableSet(directions);
    }

    public static enum RedstoneMode {
        HIGH(0),
        LOW(1),
        DISABLED(2);

        public final int index;

        private RedstoneMode(int index) {
            this.index = index;
        }

        public boolean canOperate(boolean isPowered) {
            return this == DISABLED || (isPowered ? this == HIGH : this == LOW);
        }

        public static RedstoneMode fromIndex(int index) {
            for (RedstoneMode mode : RedstoneMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }
}

