/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server.uniqueitemsettings;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.uniqueitemsettings.UniqueItemSettingsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.uniqueitemsettings.UniqueItemSettingsSPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleData(UniqueItemSettingsSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(UniqueItemSettingsSPacket packetdata, Player sender) {
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
            data.uniqueItemDisplay = ModUtils.stringExist(packetdata.value()) ? packetdata.value() : "empty";
            if (!((Boolean)ConfigHolder.COMMON.CAN_CHANGE_UNIQUE_ITEM_SETTINGS.get()).booleanValue() && ModUtils.stringExist((String)ConfigHolder.COMMON.uniqueItemDisplay.get())) {
                data.uniqueItemDisplay = (String)ConfigHolder.COMMON.uniqueItemDisplay.get();
            }
            for (Player sp : sender.level().players()) {
                Networking.sendToClient(new UniqueItemSettingsCPacket(data.uniqueItemDisplay, false, sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

