/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class CustomNameGenerator
implements NameGenerator {
    private final boolean allowDuplicates;
    private final Set<String> usedNames;

    public CustomNameGenerator(boolean allowDuplicates, Set<String> usedNames) {
        this.allowDuplicates = allowDuplicates;
        this.usedNames = usedNames;
    }

    @Override
    public Optional<Component> generateName(LevelAccessor level, Waystone waystone, RandomSource rand) {
        List<String> customNames = WaystonesConfig.getActive().worldGen.nameGenerationPresets;
        Collections.shuffle(customNames);
        for (String customName : customNames) {
            if (!this.allowDuplicates && this.usedNames.contains(customName)) continue;
            return Optional.of(Component.literal((String)customName));
        }
        return Optional.empty();
    }
}

