/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;

public class GroupChatManager {
    private static final ResourceLocation TALK_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/talk_outline.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_small_off.png");

    public static void renderIcons(GuiGraphics guiGraphics) {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        guiGraphics.pose().pushPose();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            guiGraphics.pose().translate((double)mc.getWindow().getGuiScaledWidth(), 0.0, 0.0);
        }
        if (posY < 0) {
            guiGraphics.pose().translate(0.0, (double)mc.getWindow().getGuiScaledHeight(), 0.0);
        }
        guiGraphics.pose().translate((double)posX, (double)posY, 0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            guiGraphics.pose().pushPose();
            if (vertical) {
                if (posY < 0) {
                    guiGraphics.pose().translate(0.0, (double)i * -11.0, 0.0);
                } else {
                    guiGraphics.pose().translate(0.0, (double)i * 11.0, 0.0);
                }
            } else if (posX < 0) {
                guiGraphics.pose().translate((double)i * -11.0, 0.0, 0.0);
            } else {
                guiGraphics.pose().translate((double)i * 11.0, 0.0, 0.0);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blit(TALK_OUTLINE, posX < 0 ? -10 : 0, posY < 0 ? -10 : 0, 0.0f, 0.0f, 10, 10, 16, 16);
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            PlayerSkin skin = GameProfileUtils.getSkin(state.getUuid());
            guiGraphics.blit(skin.texture(), posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.blit(skin.texture(), posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 40.0f, 8.0f, 8, 8, 64, 64);
            if (state.isDisabled()) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(posX < 0 ? -9.0 : 1.0, posY < 0 ? -9.0 : 1.0, 0.0);
                guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blit(SPEAKER_OFF_ICON, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.pose().popPose();
            }
            guiGraphics.pose().popPose();
        }
        guiGraphics.pose().popPose();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

