/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;

public abstract class DebouncedSlider
extends AbstractSliderButton {
    private boolean dragged;
    private double lastValue;

    public DebouncedSlider(int i, int j, int k, int l, Component component, double d) {
        super(i, j, k, l, component, d);
        this.lastValue = d;
    }

    public boolean keyPressed(int keyCode, int j, int k) {
        boolean result = super.keyPressed(keyCode, j, k);
        if (keyCode == 263 || keyCode == 262) {
            this.applyDebouncedInternal();
        }
        return result;
    }

    public void onClick(double d, double e) {
        super.onClick(d, e);
        this.applyDebouncedInternal();
    }

    protected void onDrag(double d, double e, double f, double g) {
        super.onDrag(d, e, f, g);
        this.dragged = true;
        if (this.value >= 1.0 || this.value <= 0.0) {
            this.applyDebouncedInternal();
            this.dragged = false;
        }
    }

    public void onRelease(double d, double e) {
        super.onRelease(d, e);
        if (this.dragged) {
            this.applyDebouncedInternal();
            this.dragged = false;
        }
    }

    private void applyDebouncedInternal() {
        if (this.value == this.lastValue) {
            return;
        }
        this.lastValue = this.value;
        this.applyDebounced();
    }

    public abstract void applyDebounced();

    protected void applyValue() {
    }
}

