/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.client.render.entity;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.render.entity.feature.GelidOverlayFeatureRenderer;
import com.faboslav.variantsandventures.common.entity.mob.GelidEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GelidEntityRenderer
extends AbstractZombieRenderer<GelidEntity, DrownedModel<GelidEntity>> {
    public static final ResourceLocation TEXTURE = VariantsAndVentures.makeID("textures/entity/gelid/gelid.png");

    public GelidEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED)), (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED_INNER_ARMOR)), (ZombieModel)new DrownedModel(context.bakeLayer(ModelLayers.DROWNED_OUTER_ARMOR)));
        this.addLayer(new GelidOverlayFeatureRenderer(this, context.getModelSet()));
    }

    protected void scale(GelidEntity gelid, PoseStack matrixStack, float f) {
        matrixStack.scale(1.0625f, 1.0625f, 1.0625f);
        super.scale((LivingEntity)gelid, matrixStack, f);
    }

    public ResourceLocation getTextureLocation(GelidEntity gelid) {
        return TEXTURE;
    }

    protected void setupRotations(GelidEntity gelid, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        super.setupRotations((LivingEntity)gelid, matrices, animationProgress, bodyYaw, tickDelta, scale);
        float i = gelid.getSwimAmount(tickDelta);
        if (i > 0.0f) {
            matrices.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)i, (float)gelid.getXRot(), (float)(-10.0f - gelid.getXRot()))));
        }
    }
}

