/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.waila;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism_integrations.waila.BloodComponent;
import de.teamlapen.vampirism_integrations.waila.WailaPlugin;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.TextureComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.PathfinderMob;

class CreatureDataProvider
implements IEntityComponentProvider {
    CreatureDataProvider() {
    }

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaPlugin.SHOW_CREATURE_INFO) && accessor.getEntity() instanceof PathfinderMob && VReference.VAMPIRE_FACTION.getPlayerCapability(accessor.getPlayer()).map(IFactionPlayer::getLevel).orElse(0) > 0) {
            VampirismAPI.getExtendedCreatureVampirism((PathfinderMob)((PathfinderMob)accessor.getEntity())).ifPresent(c -> {
                int blood = c.getBlood();
                ITooltipLine line = tooltip.addLine();
                if (c.hasPoisonousBlood()) {
                    tooltip.addLine((Component)Component.translatable((String)"text.vampirism.blood.poisonous").withStyle(ChatFormatting.DARK_GREEN));
                } else if (blood > 0) {
                    if (blood > config.getInt(WailaPlugin.MAX_BLOOD_ICONS_PER_LINE)) {
                        line.with((ITooltipComponent)new TextureComponent(BloodComponent.HALF_TEXTURE_PATH, 8, 8, 0, 0, 9, 9, 9, 9)).with((Component)Component.literal((String)String.format("%d/%d", blood, c.getMaxBlood())).withStyle(ChatFormatting.RED));
                    } else {
                        int maxPerLine = config.getInt(WailaPlugin.MAX_LONG_BLOOD_MAX);
                        line.with((ITooltipComponent)new BloodComponent(blood, c.getMaxBlood(), maxPerLine));
                    }
                }
            });
        }
    }
}

