/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.survive;

import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.WaterData;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.event.PlayerFactionEvent;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism_integrations.survive.SurviveCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SurviveHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ID = "survive";
    private static final ResourceLocation VAMPIRE_MOD_UUID = VResourceLocation.mod((String)"vampire_modifier");
    private static final ResourceLocation THIRST_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"survive", (String)"thirst_level");
    private static final ResourceLocation STAMINA_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"survive", (String)"stamina_level");
    private static final DeferredHolder<Attribute, Attribute> COLD_RESISTANCE = DeferredHolder.create((ResourceKey)ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"survive", (String)"generic.cold_resistance")));
    private static final DeferredHolder<Attribute, Attribute> HEAT_RESISTANCE = DeferredHolder.create((ResourceKey)ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"survive", (String)"generic.heat_resistance")));
    private boolean warnThirst = true;
    private boolean warnTemperature = true;
    private boolean warnStamina = true;

    @SubscribeEvent
    public void onFactionLevelChanged(PlayerFactionEvent.FactionLevelChanged event) {
        block11: {
            if (((Boolean)SurviveCompat.enableTemperatureVampires.get()).booleanValue()) {
                try {
                    AttributeInstance heatRes;
                    boolean vamp = event.getCurrentFaction() == VReference.VAMPIRE_FACTION;
                    AttributeInstance coldRes = event.getPlayer().getPlayer().getAttribute(COLD_RESISTANCE);
                    if (coldRes != null) {
                        if (vamp) {
                            if (coldRes.getModifier(VAMPIRE_MOD_UUID) == null) {
                                coldRes.addTransientModifier(new AttributeModifier(VAMPIRE_MOD_UUID, 20.0, AttributeModifier.Operation.ADD_VALUE));
                            }
                        } else {
                            coldRes.removeModifier(VAMPIRE_MOD_UUID);
                        }
                    }
                    if ((heatRes = event.getPlayer().getPlayer().getAttribute(HEAT_RESISTANCE)) != null) {
                        if (vamp) {
                            if (heatRes.getModifier(VAMPIRE_MOD_UUID) == null) {
                                heatRes.addTransientModifier(new AttributeModifier(VAMPIRE_MOD_UUID, -0.3, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                            }
                        } else {
                            heatRes.removeModifier(VAMPIRE_MOD_UUID);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!this.warnTemperature) break block11;
                    LOGGER.error("Failed to modifiy temperature resistance for vampires", e);
                    this.warnTemperature = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(EntityTickEvent event) {
        block9: {
            Entity e2;
            WaterData stats;
            IRealisticEntity realisticEntity;
            ServerPlayer player;
            block8: {
                Entity entity;
                if (((Boolean)SurviveCompat.disableThirstForVampires.get()).booleanValue() && (entity = event.getEntity()) instanceof ServerPlayer && (player = (ServerPlayer)entity) instanceof IRealisticEntity) {
                    realisticEntity = (IRealisticEntity)player;
                    try {
                        if (Helper.isVampire((Player)player) && (stats = realisticEntity.getWaterData()).needWater() && stats.getWaterLevel() < 20) {
                            stats.setWaterLevel(stats.getWaterLevel() + 1);
                        }
                    }
                    catch (Throwable e2) {
                        if (!this.warnThirst) break block8;
                        LOGGER.error("Failed to disable thirst for vampire", e2);
                        this.warnThirst = false;
                    }
                }
            }
            if (((Boolean)SurviveCompat.enableStaminaBoostVampires.get()).booleanValue() && (e2 = event.getEntity()) instanceof ServerPlayer && (player = (ServerPlayer)e2) instanceof IRealisticEntity) {
                realisticEntity = (IRealisticEntity)player;
                try {
                    if (Helper.isVampire((Player)player) && event.getEntity().tickCount % 64 == 0 && (stats = realisticEntity.staminaData()).isTired()) {
                        stats.setEnergyLevel(stats.getLTS() + 1);
                    }
                }
                catch (Throwable e3) {
                    if (!this.warnStamina) break block9;
                    LOGGER.error("Failed to grant stamina boost for vampire", e3);
                    this.warnStamina = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiLayerEvent.Pre event) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (event.getName().equals((Object)THIRST_OVERLAY) && ((Boolean)SurviveCompat.disableThirstForVampires.get()).booleanValue() && Helper.isVampire((Player)Minecraft.getInstance().player)) {
            event.setCanceled(true);
        }
        if (event.getName().equals((Object)STAMINA_OVERLAY) && ((Boolean)SurviveCompat.enableStaminaBoostVampires.get()).booleanValue() && Helper.isVampire((Player)Minecraft.getInstance().player)) {
            event.setCanceled(true);
        }
    }
}

