/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.jade.provider;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism_integrations.jade.JadePlugin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;

public enum PlayerFactionProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        CompoundTag tag;
        if (entityAccessor.getServerData().contains("playerFaction", 10) && (tag = entityAccessor.getServerData().getCompound("playerFaction")).contains("faction")) {
            String factionId = tag.getString("faction");
            int level = tag.getInt("level");
            IPlayableFaction faction = (IPlayableFaction)VampirismAPI.factionRegistry().getFactionByID(ResourceLocation.parse((String)factionId));
            MutableComponent component = Component.translatable((String)faction.getName().getString()).append(": ");
            if (tag.contains("lordTitle")) {
                int lordLevel = tag.getInt("lordLevel");
                if (IWailaConfig.get().getPlugin().get(JadePlugin.PLAYER_FACTION_LORD_LEVEL_NUMBER)) {
                    component.append((Component)Component.translatable((String)"text.vampirism.lord").append(" ").append((Component)Component.translatable((String)"text.vampirism.level"))).append(" ").append(String.valueOf(lordLevel));
                } else {
                    ComponentSerialization.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("lordTitle")).result().map(Pair::getFirst).ifPresent(arg_0 -> ((MutableComponent)component).append(arg_0));
                }
            } else {
                component.append((Component)Component.translatable((String)"text.vampirism.level")).append(" ").append(String.valueOf(level));
            }
            iTooltip.add((Component)component.withStyle(style -> style.withColor(faction.getChatColor())));
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.PLAYER_FACTION;
    }

    public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FactionPlayerHandler.getOpt((Player)player).ifPresent(handler -> handler.getCurrentFactionPlayer().ifPresent(fp -> {
                CompoundTag tag = new CompoundTag();
                IFaction currentFaction = fp.getDisguisedAs();
                if (currentFaction != null) {
                    tag.putString("faction", currentFaction.getID().toString());
                    tag.putInt("level", handler.getCurrentLevel());
                    if (handler.getLordLevel() > 0) {
                        tag.putInt("lordLevel", handler.getLordLevel());
                        DataResult tagDataResult = ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)handler.getLordTitle());
                        tagDataResult.result().ifPresent(t -> {
                            tag.putInt("lordLevel", handler.getLordLevel());
                            tag.put("lordTitle", t);
                        });
                    }
                }
                compoundTag.put("playerFaction", (Tag)tag);
            }));
        }
    }
}

