/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.mixin;

import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.world.ModDamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DamageHandler.class})
public abstract class DamageHandlerMixin {
    @Inject(method={"affectEntityHolyWaterSplash(Lnet/minecraft/world/entity/LivingEntity;Lde/teamlapen/vampirism/api/EnumStrength;DZLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lde/teamlapen/vampirism/util/Helper;isVampire(Lnet/minecraft/world/entity/Entity;)Z")}, remap=false)
    private static void affectEntityHolyWaterSplash(LivingEntity entity, EnumStrength strength, double distSq, boolean directHit, LivingEntity source, CallbackInfo ci) {
        Player player;
        int cumulative;
        if (entity instanceof Player && (cumulative = CapabilityHelper.getCumulativeTaintedAge(player = (Player)entity)) >= (Integer)HunterAgeingConfig.taintedBloodHolyWaterAffectedAge.get()) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            double amount = affect * ((double)((Integer)VampirismConfig.BALANCE.holyWaterSplashDamage.get()).intValue() * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() : (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() * (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get()))) + 0.5;
            amount = DamageHandler.scaleDamageWithLevel((int)cumulative, (int)10, (double)(amount * 0.6), (double)(amount * 1.15));
            DamageHandler.hurtModded((Entity)entity, ModDamageSources::holyWater, (float)((float)amount));
            if (strength.isStrongerThan(EnumStrength.WEAK)) {
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, ((Integer)VampirismConfig.BALANCE.holyWaterNauseaDuration.get()).intValue(), 2));
            }
            if (strength.isStrongerThan(EnumStrength.MEDIUM)) {
                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, ((Integer)VampirismConfig.BALANCE.holyWaterBlindnessDuration.get()).intValue(), 1));
            }
        }
    }
}

