/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.items;

import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.HunterAgeingType;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import com.thedrofdoctoring.vampiricageing.init.ModEffects;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaintedBloodBottleItem
extends Item
implements IFactionExclusiveItem {
    public TaintedBloodBottleItem(Item.Properties props) {
        super(props);
    }

    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack itemStack) {
        return VReference.HUNTER_FACTION;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!Helper.isHunter((Player)player)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        AgeingManager age = AgeingManager.getAge(player);
        if (age.getAge() >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get() && !((HunterAgeingType.HunterState)age.getTypeState()).isTransformed()) {
            player.startUsingItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack stack, int count) {
        if (pLivingEntity instanceof IHunterPlayer) {
            return;
        }
        if (!(pLivingEntity instanceof Player && pLivingEntity.isAlive() && ((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue())) {
            pLivingEntity.releaseUsingItem();
            return;
        }
        Player player = (Player)pLivingEntity;
        int age = AgeingManager.getAge(player).getAge();
        if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
            pLivingEntity.startUsingItem(pLivingEntity.getUsedItemHand());
        }
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (Helper.isHunter((Entity)entityLiving)) {
                int age = stack.getDamageValue();
                AgeingManager hunter = AgeingManager.getAge(player);
                HunterAgeingType.HunterState state = (HunterAgeingType.HunterState)hunter.getTypeState();
                state.setTemporaryTaintedTicks((Integer)HunterAgeingConfig.temporaryTaintedBloodBaseTicks.get() * hunter.getAge());
                state.setTemporaryTaintedAgeBonus(age);
                entityLiving.addEffect(new MobEffectInstance(ModEffects.TAINTED_BLOOD_EFFECT, (Integer)HunterAgeingConfig.temporaryTaintedBloodBaseTicks.get() * hunter.getAge(), 0, false, false));
                stack.shrink(1);
                if (entityLiving instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)entityLiving;
                    hunter.getType().handleSkills(hunter.getAge(), sp);
                    hunter.onAgeChange(sp, hunter.getAgeType());
                }
            }
        }
        return super.finishUsingItem(stack, worldIn, entityLiving);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 45;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> components, TooltipFlag pTooltipFlag) {
        components.add((Component)Component.translatable((String)"text.vampiricageing.tainted_blood_useage", (Object[])new Object[]{HunterAgeingConfig.taintedBloodBottleAge.get()}).withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.translatable((String)"text.vampiricageing.tainted_blood_rank", (Object[])new Object[]{pStack.getDamageValue()}).withStyle(ChatFormatting.RED));
        super.appendHoverText(pStack, pContext, components, pTooltipFlag);
    }
}

