/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.ageing.types;

import com.thedrofdoctoring.vampiricageing.VampiricAgeing;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import com.thedrofdoctoring.vampiricageing.skills.VampiricAgeingSkills;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class VampireAgeingType
implements IAgeType {
    private static final String id = "VAMPIRE";

    @Override
    public IPlayableFaction<?> faction() {
        return VReference.VAMPIRE_FACTION;
    }

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getAgeAttributes(int age, Player player, boolean cleanup) {
        HashMap<Holder<Attribute>, AttributeModifier> attributeMap = new HashMap<Holder<Attribute>, AttributeModifier>();
        if (age > 0 && age >= (Integer)CommonConfig.stepAssistBonus.get()) {
            attributeMap.put(Attributes.STEP_HEIGHT, new AttributeModifier(VampiricAgeing.rl("vamp_ageing_step_height"), 0.5, AttributeModifier.Operation.ADD_VALUE));
        }
        if (((Boolean)CommonConfig.shouldAgeAffectExhaustion.get()).booleanValue()) {
            attributeMap.put((Holder<Attribute>)ModAttributes.BLOOD_EXHAUSTION, new AttributeModifier(VampiricAgeing.rl("vamp_ageing_exhaustion"), ((Double)((List)CommonConfig.ageExhaustionEffect.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        attributeMap.put(Attributes.ATTACK_DAMAGE, new AttributeModifier(VampiricAgeing.rl("vamp_ageing_attack_damage"), ((Double)((List)CommonConfig.ageDamageIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        attributeMap.put(Attributes.MAX_HEALTH, new AttributeModifier(VampiricAgeing.rl("vamp_ageing_max_health"), ((Double)((List)CommonConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        attributeMap.put((Holder<Attribute>)ModAttributes.DBNO_DURATION, new AttributeModifier(VampiricAgeing.rl("vamp_ageing_dbno_duration"), ((Double)((List)CommonConfig.DBNOTimeMultiplier.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attributeMap.put((Holder<Attribute>)ModAttributes.NEONATAL_DURATION, new AttributeModifier(VampiricAgeing.rl("vamp_ageing_neonatal_duration"), ((Double)((List)CommonConfig.neonatalTimeMultiplier.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attributeMap;
    }

    @Override
    public void handleSkills(int age, ServerPlayer player) {
        ISkillHandler skillHandler = VampirePlayer.get((Player)player).getSkillHandler();
        if (age >= (Integer)CommonConfig.ageWaterWalkingRank.get()) {
            skillHandler.enableSkill((ISkill)VampiricAgeingSkills.WATER_WALKING_SKILL.get());
        } else {
            skillHandler.disableSkill((ISkill)VampiricAgeingSkills.WATER_WALKING_SKILL.get());
        }
        if (age >= (Integer)CommonConfig.celerityActionRank.get()) {
            skillHandler.enableSkill((ISkill)VampiricAgeingSkills.CELERTIY_ACTION.get());
        } else {
            skillHandler.disableSkill((ISkill)VampiricAgeingSkills.CELERTIY_ACTION.get());
        }
        if (age >= (Integer)CommonConfig.drainBloodActionRank.get()) {
            skillHandler.enableSkill((ISkill)VampiricAgeingSkills.BLOOD_DRAIN_SKILL.get());
        } else {
            skillHandler.disableSkill((ISkill)VampiricAgeingSkills.BLOOD_DRAIN_SKILL.get());
        }
    }

    @Override
    public int minFactionRank() {
        return (Integer)CommonConfig.levelToBeginAgeMechanic.get();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CommonConfig.vampireAgeing.get();
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getAgeTitle(int ageRank) {
        return (String)((List)CommonConfig.vampireAgeRankTitles.get()).get(ageRank - 1);
    }

    public Optional<TypeState> getStateType() {
        return Optional.empty();
    }
}

